/*
 * Decompiled with CFR 0.152.
 */
package com.alee.extended.tree;

import com.alee.extended.tree.NodesTransferable;
import com.alee.extended.tree.TreeDropHandler;
import com.alee.laf.tree.UniqueNode;
import com.alee.laf.tree.WebTree;
import com.alee.managers.log.Log;
import com.alee.utils.CollectionUtils;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JTree;
import javax.swing.TransferHandler;

public class NodesDropHandler<N extends UniqueNode, T extends WebTree<N>>
implements TreeDropHandler<N, T> {
    protected ArrayList<DataFlavor> flavors;

    @Override
    public List<DataFlavor> getSupportedFlavors() {
        if (this.flavors == null) {
            this.flavors = CollectionUtils.asList((Object[])new DataFlavor[]{NodesTransferable.FLAVOR});
        }
        return this.flavors;
    }

    @Override
    public boolean canDrop(TransferHandler.TransferSupport support, T tree, N destination) {
        try {
            List nodes = (List)support.getTransferable().getTransferData(NodesTransferable.FLAVOR);
            JTree.DropLocation dl = (JTree.DropLocation)support.getDropLocation();
            return this.canBeDropped(tree, nodes, destination, dl.getChildIndex());
        }
        catch (UnsupportedFlavorException ufe) {
            Log.warn((Object)this, (String)("UnsupportedFlavor: " + ufe.getMessage()));
            return false;
        }
        catch (IOException ioe) {
            Log.error((Object)this, (String)("I/O exception: " + ioe.getMessage()));
            return false;
        }
    }

    protected boolean canBeDropped(T tree, List<N> nodes, N dropLocation, int dropIndex) {
        return true;
    }

    @Override
    public List<N> getDroppedNodes(TransferHandler.TransferSupport support, T tree, N destination) {
        try {
            return (List)support.getTransferable().getTransferData(NodesTransferable.FLAVOR);
        }
        catch (UnsupportedFlavorException ufe) {
            Log.warn((Object)this, (String)("UnsupportedFlavor: " + ufe.getMessage()));
            return null;
        }
        catch (IOException ioe) {
            Log.error((Object)this, (String)("I/O exception: " + ioe.getMessage()));
            return null;
        }
    }
}

