/*
 * Decompiled with CFR 0.152.
 */
package com.alee.extended.tree;

import com.alee.extended.tree.WebAsyncTree;
import com.alee.utils.concurrent.DaemonThreadFactory;
import java.util.Map;
import java.util.WeakHashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;

public final class AsyncTreeQueue {
    public static int threadsAmount = 4;
    public static boolean separateLimitForEachTree = true;
    private static final Map<WebAsyncTree, AsyncTreeQueue> queues = new WeakHashMap<WebAsyncTree, AsyncTreeQueue>();
    private final Object lock = new Object();
    private ExecutorService executorService = Executors.newFixedThreadPool(threadsAmount, (ThreadFactory)new DaemonThreadFactory());

    public static void setMaximumThreadsAmount(WebAsyncTree asyncTree, int amount) {
        AsyncTreeQueue.getInstance(asyncTree).setMaximumThreadsAmount(amount);
    }

    public static void execute(WebAsyncTree asyncTree, Runnable runnable) {
        AsyncTreeQueue.getInstance(asyncTree).execute(runnable);
    }

    public static AsyncTreeQueue getInstance(WebAsyncTree asyncTree) {
        if (separateLimitForEachTree) {
            return AsyncTreeQueue.getInstanceImpl(asyncTree);
        }
        return AsyncTreeQueue.getInstanceImpl(null);
    }

    private static AsyncTreeQueue getInstanceImpl(WebAsyncTree asyncTree) {
        AsyncTreeQueue queue = queues.get(asyncTree);
        if (queue == null) {
            if (asyncTree == null) {
                AsyncTreeQueue.shutdownAllQueues();
            }
            queue = new AsyncTreeQueue();
            queues.put(asyncTree, queue);
        }
        return queue;
    }

    private static void shutdownAllQueues() {
        for (Map.Entry<WebAsyncTree, AsyncTreeQueue> queueEntry : queues.entrySet()) {
            queueEntry.getValue().shutdown();
        }
    }

    private AsyncTreeQueue() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setMaximumThreadsAmount(int amount) {
        Object object = this.lock;
        synchronized (object) {
            if (this.executorService != null) {
                this.executorService.shutdown();
            }
            this.executorService = amount > 0 ? Executors.newFixedThreadPool(amount, (ThreadFactory)new DaemonThreadFactory()) : null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void shutdown() {
        Object object = this.lock;
        synchronized (object) {
            if (this.executorService != null) {
                this.executorService.shutdown();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute(Runnable runnable) {
        Object object = this.lock;
        synchronized (object) {
            if (this.executorService != null) {
                this.executorService.execute(runnable);
            } else {
                new Thread(runnable, "AsyncTreeQueue").start();
            }
        }
    }
}

