/*
 * Decompiled with CFR 0.152.
 */
package com.alee.extended.tab;

import com.alee.extended.tab.DocumentData;
import com.alee.extended.tab.PaneData;
import com.alee.extended.tab.TabTitleComponentProvider;
import com.alee.extended.tab.WebDocumentPane;
import com.alee.laf.button.WebButton;
import com.alee.laf.label.WebLabel;
import com.alee.laf.panel.WebPanel;
import com.alee.managers.style.StyleId;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import javax.swing.Icon;
import javax.swing.JComponent;

public class DefaultTabTitleComponentProvider<T extends DocumentData>
implements TabTitleComponentProvider<T> {
    @Override
    public JComponent createTabTitleComponent(PaneData<T> paneData, T document, MouseAdapter mouseAdapter) {
        WebPanel tabTitleComponent = new WebPanel(StyleId.panelTransparent, new BorderLayout(2, 0), new Component[0]);
        tabTitleComponent.addMouseListener(mouseAdapter);
        tabTitleComponent.addMouseMotionListener(mouseAdapter);
        tabTitleComponent.add((Component)this.createTitleLabel(paneData, document, mouseAdapter), (Object)"Center");
        if (paneData.getDocumentPane().isCloseable() && ((DocumentData)document).isCloseable()) {
            tabTitleComponent.add((Component)this.createCloseButton(paneData, document), (Object)"After");
        }
        return tabTitleComponent;
    }

    protected WebLabel createTitleLabel(PaneData<T> paneData, T document, MouseAdapter mouseAdapter) {
        WebLabel titleLabel = new WebLabel(((DocumentData)document).getTitle(), ((DocumentData)document).getIcon());
        titleLabel.setForeground(((DocumentData)document).getForeground());
        titleLabel.addMouseListener(mouseAdapter);
        titleLabel.addMouseMotionListener(mouseAdapter);
        return titleLabel;
    }

    protected WebButton createCloseButton(final PaneData<T> paneData, T document) {
        StyleId closeButtonId = StyleId.documentpaneCloseButton.at(paneData.getTabbedPane());
        WebButton closeButton = new WebButton(closeButtonId, (Icon)WebDocumentPane.closeTabIcon, (Icon)WebDocumentPane.closeTabRolloverIcon);
        closeButton.addActionListener(new ActionListener((DocumentData)document){
            final /* synthetic */ DocumentData val$document;
            {
                this.val$document = documentData;
            }

            @Override
            public void actionPerformed(ActionEvent e) {
                paneData.close(this.val$document);
            }
        });
        return closeButton;
    }
}

