/*
 * Decompiled with CFR 0.152.
 */
package com.alee.extended.ninepatch;

import com.alee.extended.drag.FileDragAndDropHandler;
import com.alee.extended.layout.TableLayout;
import com.alee.extended.ninepatch.NinePatchEditor;
import com.alee.extended.ninepatch.NinePatchInfo;
import com.alee.extended.ninepatch.ZoomChangeListener;
import com.alee.extended.panel.ResizablePanel;
import com.alee.extended.statusbar.WebStatusBar;
import com.alee.extended.tree.WebFileTree;
import com.alee.global.GlobalConstants;
import com.alee.laf.button.WebButton;
import com.alee.laf.button.WebToggleButton;
import com.alee.laf.colorchooser.WebColorChooserDialog;
import com.alee.laf.filechooser.WebFileChooser;
import com.alee.laf.grouping.GroupPane;
import com.alee.laf.label.WebLabel;
import com.alee.laf.optionpane.WebOptionPane;
import com.alee.laf.panel.WebPanel;
import com.alee.laf.scroll.WebScrollPane;
import com.alee.laf.slider.WebSlider;
import com.alee.laf.splitpane.WebSplitPane;
import com.alee.laf.text.WebTextField;
import com.alee.laf.toolbar.WebToolBar;
import com.alee.laf.tree.TreeSelectionStyle;
import com.alee.managers.hotkey.Hotkey;
import com.alee.managers.language.LanguageManager;
import com.alee.managers.log.Log;
import com.alee.managers.settings.SettingsManager;
import com.alee.managers.style.StyleId;
import com.alee.painter.common.ColorPainter;
import com.alee.skin.ninepatch.NPLabelPainter;
import com.alee.utils.CollectionUtils;
import com.alee.utils.ImageUtils;
import com.alee.utils.NinePatchUtils;
import com.alee.utils.SwingUtils;
import com.alee.utils.SystemUtils;
import com.alee.utils.XmlUtils;
import com.alee.utils.compare.Filter;
import com.alee.utils.ninepatch.NinePatchInterval;
import com.alee.utils.ninepatch.NinePatchIntervalType;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Image;
import java.awt.Toolkit;
import java.awt.datatransfer.StringSelection;
import java.awt.datatransfer.Transferable;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import javax.imageio.ImageIO;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.TransferHandler;
import javax.swing.event.CaretEvent;
import javax.swing.event.CaretListener;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.filechooser.FileFilter;

public class NinePatchEditorPanel
extends WebPanel {
    public static final ImageIcon OPEN_ICON = new ImageIcon(NinePatchEditorPanel.class.getResource("icons/open.png"));
    public static final ImageIcon SAVE_ICON = new ImageIcon(NinePatchEditorPanel.class.getResource("icons/save.png"));
    public static final ImageIcon SAVE_AS_ICON = new ImageIcon(NinePatchEditorPanel.class.getResource("icons/saveas.png"));
    public static final ImageIcon UNDO_ICON = new ImageIcon(NinePatchEditorPanel.class.getResource("icons/undo.png"));
    public static final ImageIcon REDO_ICON = new ImageIcon(NinePatchEditorPanel.class.getResource("icons/redo.png"));
    public static final ImageIcon COPY_ICON = new ImageIcon(NinePatchEditorPanel.class.getResource("icons/copy.png"));
    public static final ImageIcon PASTE_ICON = new ImageIcon(NinePatchEditorPanel.class.getResource("icons/paste.png"));
    public static final ImageIcon ROTATE_CCW_ICON = new ImageIcon(NinePatchEditorPanel.class.getResource("icons/rotate_ccw.png"));
    public static final ImageIcon ROTATE_CW_ICON = new ImageIcon(NinePatchEditorPanel.class.getResource("icons/rotate_cw.png"));
    public static final ImageIcon ROTATE_180_ICON = new ImageIcon(NinePatchEditorPanel.class.getResource("icons/rotate_180.png"));
    public static final ImageIcon GUIDES_ICON = new ImageIcon(NinePatchEditorPanel.class.getResource("icons/guides.png"));
    public static final ImageIcon RULER_ICON = new ImageIcon(NinePatchEditorPanel.class.getResource("icons/ruler.png"));
    public static final ImageIcon STRETCH_ICON = new ImageIcon(NinePatchEditorPanel.class.getResource("icons/stretch.png"));
    public static final ImageIcon CONTENT_ICON = new ImageIcon(NinePatchEditorPanel.class.getResource("icons/content.png"));
    public static final ImageIcon RULER_CURSOR_ICON = new ImageIcon(NinePatchEditorPanel.class.getResource("icons/ruler_cursor.png"));
    public static final ImageIcon AREA_CURSOR_ICON = new ImageIcon(NinePatchEditorPanel.class.getResource("icons/area_cursor.png"));
    public static final ImageIcon MIN_ICON = new ImageIcon(NinePatchEditorPanel.class.getResource("icons/min.png"));
    public static final ImageIcon MAX_ICON = new ImageIcon(NinePatchEditorPanel.class.getResource("icons/max.png"));
    public static final ImageIcon ICON = new ImageIcon(NinePatchEditorPanel.class.getResource("icons/icon.png"));
    public static final ImageIcon SHOW_ICON_ICON = new ImageIcon(NinePatchEditorPanel.class.getResource("icons/show_icon.png"));
    public static final ImageIcon SHOW_TEXT_ICON = new ImageIcon(NinePatchEditorPanel.class.getResource("icons/show_text.png"));
    public static final ImageIcon FOREGROUND_COLOR_ICON = new ImageIcon(NinePatchEditorPanel.class.getResource("icons/foreground_color.png"));
    public static final ImageIcon TRANSPARENT_ICON = new ImageIcon(NinePatchEditorPanel.class.getResource("icons/transparent.png"));
    public static final ImageIcon BACKGROUND_COLOR_ICON = new ImageIcon(NinePatchEditorPanel.class.getResource("icons/background_color.png"));
    private final List<ChangeListener> changeListeners = new ArrayList<ChangeListener>(1);
    private String imageSrc = null;
    private final WebFileTree fileTree;
    private NinePatchEditor ninePatchEditor;
    private WebButton save;
    private WebButton saveAs;
    private ChangeListener changeListener;
    private ZoomChangeListener zoomChangeListener;
    private WebPanel previewPanel;
    private WebLabel preview;
    private final StyleId previewBackgroundId = StyleId.ninepatcheditorPreviewBackground.at(this);
    private Color previewColor;
    private boolean openFromTreeEnabled = true;
    private static boolean aliasesInitialized = false;

    public NinePatchEditorPanel() {
        super(StyleId.ninepatcheditor, new BorderLayout(), new Component[0]);
        NinePatchEditorPanel.initializeAliases();
        this.fileTree = new WebFileTree();
        this.fileTree.setSelectionStyle(TreeSelectionStyle.single);
        this.fileTree.setSelectionMode(1);
        this.fileTree.setFileFilter((Filter<File>)GlobalConstants.IMAGES_AND_FOLDERS_FILTER);
        this.fileTree.addTreeSelectionListener(new TreeSelectionListener(){

            @Override
            public void valueChanged(TreeSelectionEvent e) {
                if (NinePatchEditorPanel.this.openFromTreeEnabled && NinePatchEditorPanel.this.fileTree.getSelectionCount() > 0) {
                    NinePatchEditorPanel.this.openImage(NinePatchEditorPanel.this.fileTree.getSelectedFile());
                }
            }
        });
        this.fileTree.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (e.getClickCount() == 2 && NinePatchEditorPanel.this.openFromTreeEnabled && NinePatchEditorPanel.this.fileTree.getSelectionCount() > 0) {
                    NinePatchEditorPanel.this.openImage(NinePatchEditorPanel.this.fileTree.getSelectedFile());
                }
            }
        });
        this.fileTree.setTransferHandler(new TransferHandler(){

            @Override
            public int getSourceActions(JComponent c) {
                return 1;
            }

            @Override
            protected Transferable createTransferable(JComponent c) {
                return NinePatchEditorPanel.this.fileTree.getSelectionCount() > 0 ? new StringSelection(NinePatchEditorPanel.this.fileTree.getSelectedFile().getAbsolutePath()) : null;
            }
        });
        WebScrollPane filesView = new WebScrollPane(StyleId.scrollpaneUndecorated, this.fileTree);
        filesView.setMinimumWidth(200);
        filesView.setPreferredHeight(0);
        final WebSplitPane previewSplit = new WebSplitPane(1);
        previewSplit.setLeftComponent(this.createEditorPanel());
        previewSplit.setRightComponent(this.createPreviewPanel());
        previewSplit.setOneTouchExpandable(true);
        previewSplit.setContinuousLayout(true);
        previewSplit.setResizeWeight(1.0);
        final WebSplitPane filesSplit = new WebSplitPane(1);
        filesSplit.setLeftComponent(filesView);
        filesSplit.setRightComponent(previewSplit);
        filesSplit.setOneTouchExpandable(true);
        filesSplit.setContinuousLayout(true);
        filesSplit.setResizeWeight(0.0);
        this.add((Component)filesSplit, (Object)"Center");
        Integer fsl = (Integer)SettingsManager.get((String)"NinePatchEditor", (String)"filesSplitLocation", (Object)null);
        filesSplit.setDividerLocation(fsl != null ? fsl : 230);
        filesSplit.addPropertyChangeListener("dividerLocation", new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent pce) {
                SettingsManager.set((String)"NinePatchEditor", (String)"filesSplitLocation", (Object)filesSplit.getDividerLocation());
            }
        });
        Integer psl = (Integer)SettingsManager.get((String)"NinePatchEditor", (String)"splitLocation", (Object)null);
        if (psl != null) {
            previewSplit.setDividerLocation(psl);
        }
        previewSplit.addPropertyChangeListener("dividerLocation", new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent pce) {
                SettingsManager.set((String)"NinePatchEditor", (String)"splitLocation", (Object)previewSplit.getDividerLocation());
            }
        });
        LanguageManager.updateComponentsTree((JComponent)this);
    }

    private Component createEditorPanel() {
        WebPanel editorPanel = new WebPanel();
        WebToolBar toolBar = new WebToolBar(StyleId.ninepatcheditorToolbar.at(this), 0);
        editorPanel.add((Component)toolBar, (Object)"North");
        WebButton open = new WebButton(OPEN_ICON);
        open.setStyleId(StyleId.buttonIconHover);
        open.setLanguage("weblaf.ex.npeditor.openImage", new Object[0]);
        open.addHotkey(this, Hotkey.CTRL_O);
        open.addActionListener(new ActionListener(){
            private WebFileChooser wfc = null;

            @Override
            public void actionPerformed(ActionEvent e) {
                if (this.wfc == null) {
                    this.wfc = new WebFileChooser(NinePatchEditorPanel.this.imageSrc);
                    this.wfc.setDialogTitleKey("weblaf.ex.npeditor.openImage.title");
                    this.wfc.setMultiSelectionEnabled(false);
                    this.wfc.addChoosableFileFilter((FileFilter)GlobalConstants.IMAGES_FILTER);
                    this.wfc.setFileFilter((FileFilter)GlobalConstants.IMAGES_FILTER);
                }
                if (NinePatchEditorPanel.this.imageSrc != null) {
                    this.wfc.setSelectedFile(NinePatchEditorPanel.this.imageSrc);
                }
                if (this.wfc.showOpenDialog(SwingUtils.getWindowAncestor((Component)NinePatchEditorPanel.this)) == 0) {
                    NinePatchEditorPanel.this.openImage(this.wfc.getSelectedFile());
                }
            }
        });
        toolBar.add((Component)open);
        toolBar.addSeparator();
        this.save = new WebButton(SAVE_ICON);
        this.save.setStyleId(StyleId.buttonIconHover);
        this.save.setLanguage("weblaf.ex.npeditor.saveImage", new Object[0]);
        this.save.addHotkey(this, Hotkey.CTRL_S);
        this.save.setEnabled(false);
        this.save.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (NinePatchEditorPanel.this.imageSrc != null) {
                    try {
                        NinePatchEditorPanel.this.saveImage(new File(NinePatchEditorPanel.this.imageSrc));
                    }
                    catch (IOException e1) {
                        Log.error((Object)this, (Throwable)e1);
                    }
                }
            }
        });
        toolBar.add((Component)this.save);
        this.saveAs = new WebButton(SAVE_AS_ICON);
        this.saveAs.setStyleId(StyleId.buttonIconHover);
        this.saveAs.setLanguage("weblaf.ex.npeditor.saveImageAs", new Object[0]);
        this.saveAs.addHotkey(this, Hotkey.CTRL_SHIFT_S);
        this.saveAs.addActionListener(new ActionListener(){
            private WebFileChooser wfc = null;

            @Override
            public void actionPerformed(ActionEvent e) {
                if (this.wfc == null) {
                    this.wfc = new WebFileChooser(NinePatchEditorPanel.this.imageSrc);
                    this.wfc.setDialogTitleKey("weblaf.ex.npeditor.saveImageAs.title");
                    this.wfc.setMultiSelectionEnabled(false);
                }
                if (NinePatchEditorPanel.this.imageSrc != null) {
                    this.wfc.setSelectedFile(NinePatchEditorPanel.this.imageSrc);
                }
                if (this.wfc.showSaveDialog(SwingUtils.getWindowAncestor((Component)NinePatchEditorPanel.this)) == 0) {
                    try {
                        NinePatchEditorPanel.this.saveImage(this.wfc.getSelectedFile());
                        NinePatchEditorPanel.this.save.setEnabled(true);
                    }
                    catch (IOException e1) {
                        Log.error((Object)this, (Throwable)e1);
                    }
                }
            }
        });
        toolBar.add((Component)this.saveAs);
        toolBar.addSeparator();
        WebButton undo = new WebButton(UNDO_ICON);
        undo.setStyleId(StyleId.buttonIconHover);
        undo.setLanguage("weblaf.ex.npeditor.undo", new Object[0]);
        undo.addHotkey(this, Hotkey.CTRL_Z);
        undo.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                NinePatchEditorPanel.this.ninePatchEditor.undo();
            }
        });
        toolBar.add((Component)undo);
        WebButton redo = new WebButton(REDO_ICON);
        redo.setStyleId(StyleId.buttonIconHover);
        redo.setLanguage("weblaf.ex.npeditor.redo", new Object[0]);
        redo.addHotkey(this, Hotkey.CTRL_R).setHidden(true);
        redo.addHotkey(this, Hotkey.CTRL_SHIFT_Z);
        redo.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                NinePatchEditorPanel.this.ninePatchEditor.redo();
            }
        });
        toolBar.add((Component)redo);
        this.ninePatchEditor = new NinePatchEditor();
        this.ninePatchEditor.setTransferHandler(new FileDragAndDropHandler(){

            @Override
            public boolean filesDropped(List<File> files) {
                if (files != null) {
                    for (File file : files) {
                        if (!ImageUtils.isImageLoadable((String)file.getName())) continue;
                        NinePatchEditorPanel.this.openImage(file);
                        return true;
                    }
                }
                return false;
            }
        });
        editorPanel.add((Component)this.ninePatchEditor.getView(), (Object)"Center");
        WebButton copy = new WebButton(COPY_ICON);
        copy.setStyleId(StyleId.buttonIconHover);
        copy.setLanguage("weblaf.ex.npeditor.copyInfo", new Object[0]);
        copy.addHotkey(this, Hotkey.CTRL_C);
        copy.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (!NinePatchEditorPanel.this.ninePatchEditor.isSomeDragged()) {
                    SystemUtils.copyToClipboard((String)XmlUtils.toXML((Object)NinePatchEditorPanel.this.ninePatchEditor.getNinePatchInfo()));
                }
            }
        });
        toolBar.addToEnd(copy);
        WebButton paste = new WebButton(PASTE_ICON);
        paste.setStyleId(StyleId.buttonIconHover);
        paste.setLanguage("weblaf.ex.npeditor.pasteInfo", new Object[0]);
        paste.addHotkey(this, Hotkey.CTRL_V);
        paste.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                String xml;
                if (!NinePatchEditorPanel.this.ninePatchEditor.isSomeDragged() && (xml = SystemUtils.getStringFromClipboard()) != null) {
                    NinePatchInfo info = (NinePatchInfo)XmlUtils.fromXML((String)xml);
                    NinePatchEditorPanel.this.ninePatchEditor.setNinePatchInfo(info);
                }
            }
        });
        toolBar.addToEnd(paste);
        toolBar.addSeparatorToEnd();
        WebButton rotateCCW = new WebButton(ROTATE_CCW_ICON);
        rotateCCW.setStyleId(StyleId.buttonIconHover);
        rotateCCW.setLanguage("weblaf.ex.npeditor.rotateCCW", new Object[0]);
        rotateCCW.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (!NinePatchEditorPanel.this.ninePatchEditor.isSomeDragged()) {
                    NinePatchEditorPanel.this.ninePatchEditor.setNinePatchIcon(NinePatchUtils.rotateIcon90CCW(NinePatchEditorPanel.this.ninePatchEditor.getNinePatchIcon()));
                }
            }
        });
        toolBar.addToEnd(rotateCCW);
        WebButton rotateCW = new WebButton(ROTATE_CW_ICON);
        rotateCW.setStyleId(StyleId.buttonIconHover);
        rotateCW.setLanguage("weblaf.ex.npeditor.rotateCW", new Object[0]);
        rotateCW.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (!NinePatchEditorPanel.this.ninePatchEditor.isSomeDragged()) {
                    NinePatchEditorPanel.this.ninePatchEditor.setNinePatchIcon(NinePatchUtils.rotateIcon90CW(NinePatchEditorPanel.this.ninePatchEditor.getNinePatchIcon()));
                }
            }
        });
        toolBar.addToEnd(rotateCW);
        WebButton rotate180 = new WebButton(ROTATE_180_ICON);
        rotate180.setStyleId(StyleId.buttonIconHover);
        rotate180.setLanguage("weblaf.ex.npeditor.rotate180", new Object[0]);
        rotate180.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (!NinePatchEditorPanel.this.ninePatchEditor.isSomeDragged()) {
                    NinePatchEditorPanel.this.ninePatchEditor.setNinePatchIcon(NinePatchUtils.rotateIcon180(NinePatchEditorPanel.this.ninePatchEditor.getNinePatchIcon()));
                }
            }
        });
        toolBar.addToEnd(rotate180);
        WebStatusBar bottomToolBar = new WebStatusBar();
        editorPanel.add((Component)bottomToolBar, (Object)"South");
        boolean sgs = (Boolean)SettingsManager.get((String)"NinePatchEditor", (String)"showSpacing", (Object)true);
        final WebToggleButton showGuidesSpacing = new WebToggleButton(GUIDES_ICON);
        showGuidesSpacing.setStyleId(StyleId.togglebuttonIconHover);
        showGuidesSpacing.setLanguage("weblaf.ex.npeditor.showSpacing", new Object[0]);
        showGuidesSpacing.setSelected(sgs);
        this.ninePatchEditor.setShowGuideSpacing(sgs);
        showGuidesSpacing.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                boolean sgs = showGuidesSpacing.isSelected();
                SettingsManager.set((String)"NinePatchEditor", (String)"showSpacing", (Object)sgs);
                NinePatchEditorPanel.this.ninePatchEditor.setShowGuideSpacing(sgs);
            }
        });
        boolean sr = (Boolean)SettingsManager.get((String)"NinePatchEditor", (String)"showRuler", (Object)true);
        final WebToggleButton showRuler = new WebToggleButton(RULER_ICON);
        showRuler.setStyleId(StyleId.togglebuttonIconHover);
        showRuler.setLanguage("weblaf.ex.npeditor.showRuler", new Object[0]);
        showRuler.setSelected(sr);
        this.ninePatchEditor.setShowRuler(sr);
        showRuler.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                boolean sr = showRuler.isSelected();
                SettingsManager.set((String)"NinePatchEditor", (String)"showRuler", (Object)sr);
                NinePatchEditorPanel.this.ninePatchEditor.setShowRuler(sr);
            }
        });
        boolean fc = (Boolean)SettingsManager.get((String)"NinePatchEditor", (String)"fillContent", (Object)true);
        final WebToggleButton fillContent = new WebToggleButton(CONTENT_ICON);
        fillContent.setStyleId(StyleId.togglebuttonIconHover);
        fillContent.setLanguage("weblaf.ex.npeditor.fillContent", new Object[0]);
        fillContent.setSelected(fc);
        this.ninePatchEditor.setFillContentArea(fc);
        fillContent.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                boolean fc = fillContent.isSelected();
                SettingsManager.set((String)"NinePatchEditor", (String)"fillContent", (Object)fc);
                NinePatchEditorPanel.this.ninePatchEditor.setFillContentArea(fc);
            }
        });
        boolean fs = (Boolean)SettingsManager.get((String)"NinePatchEditor", (String)"fillStretch", (Object)true);
        final WebToggleButton fillStretch = new WebToggleButton(STRETCH_ICON);
        fillStretch.setStyleId(StyleId.togglebuttonIconHover);
        fillStretch.setLanguage("weblaf.ex.npeditor.fillStretch", new Object[0]);
        fillStretch.setSelected(fs);
        this.ninePatchEditor.setFillStretchAreas(fs);
        fillStretch.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                boolean fs = fillStretch.isSelected();
                SettingsManager.set((String)"NinePatchEditor", (String)"fillStretch", (Object)fs);
                NinePatchEditorPanel.this.ninePatchEditor.setFillStretchAreas(fs);
            }
        });
        boolean rc = (Boolean)SettingsManager.get((String)"NinePatchEditor", (String)"rulerCursor", (Object)true);
        final WebToggleButton rulerCursor = new WebToggleButton(RULER_CURSOR_ICON);
        rulerCursor.setStyleId(StyleId.togglebuttonIconHover);
        rulerCursor.setLanguage("weblaf.ex.npeditor.rulerCursor", new Object[0]);
        rulerCursor.setSelected(rc);
        this.ninePatchEditor.setShowRulerCursorPosition(rc);
        rulerCursor.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                boolean rc = rulerCursor.isSelected();
                SettingsManager.set((String)"NinePatchEditor", (String)"rulerCursor", (Object)rc);
                NinePatchEditorPanel.this.ninePatchEditor.setShowRulerCursorPosition(rc);
            }
        });
        boolean ac = (Boolean)SettingsManager.get((String)"NinePatchEditor", (String)"areaCursor", (Object)false);
        final WebToggleButton areaCursor = new WebToggleButton(AREA_CURSOR_ICON);
        areaCursor.setStyleId(StyleId.togglebuttonIconHover);
        areaCursor.setLanguage("weblaf.ex.npeditor.areaCursor", new Object[0]);
        areaCursor.setSelected(ac);
        this.ninePatchEditor.setShowAreaCursorPosition(ac);
        areaCursor.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                boolean ac = areaCursor.isSelected();
                SettingsManager.set((String)"NinePatchEditor", (String)"areaCursor", (Object)ac);
                NinePatchEditorPanel.this.ninePatchEditor.setShowAreaCursorPosition(ac);
            }
        });
        boolean minZ = true;
        int maxZ = 32;
        StyleId zoomSliderId = StyleId.ninepatcheditorZoomSlider.at(this);
        final WebSlider zoomSlider = new WebSlider(zoomSliderId, 1, 32, this.ninePatchEditor.getZoom());
        zoomSlider.setPreferredWidth(170);
        this.changeListener = new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                NinePatchEditorPanel.this.ninePatchEditor.removeZoomChangeListener(NinePatchEditorPanel.this.zoomChangeListener);
                NinePatchEditorPanel.this.ninePatchEditor.setZoom(zoomSlider.getValue());
                NinePatchEditorPanel.this.ninePatchEditor.addZoomChangeListener(NinePatchEditorPanel.this.zoomChangeListener);
            }
        };
        zoomSlider.addChangeListener(this.changeListener);
        this.zoomChangeListener = new ZoomChangeListener(){

            @Override
            public void zoomChanged() {
                zoomSlider.removeChangeListener(NinePatchEditorPanel.this.changeListener);
                zoomSlider.setValue(NinePatchEditorPanel.this.ninePatchEditor.getZoom());
                zoomSlider.addChangeListener(NinePatchEditorPanel.this.changeListener);
            }
        };
        this.ninePatchEditor.addZoomChangeListener(this.zoomChangeListener);
        WebButton minZoom = new WebButton(MIN_ICON);
        minZoom.setStyleId(StyleId.buttonIconHover);
        minZoom.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                zoomSlider.setValue(1);
            }
        });
        WebButton maxZoom = new WebButton(MAX_ICON);
        maxZoom.setStyleId(StyleId.buttonIconHover);
        maxZoom.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                zoomSlider.setValue(32);
            }
        });
        bottomToolBar.add(showGuidesSpacing);
        bottomToolBar.add(showRuler);
        bottomToolBar.addSeparator();
        bottomToolBar.add(fillContent);
        bottomToolBar.add(fillStretch);
        bottomToolBar.addSeparator();
        bottomToolBar.add(rulerCursor);
        bottomToolBar.add(areaCursor);
        bottomToolBar.addToEnd(minZoom);
        bottomToolBar.addToEnd(zoomSlider);
        bottomToolBar.addToEnd(maxZoom);
        return editorPanel;
    }

    private static void initializeAliases() {
        if (!aliasesInitialized) {
            aliasesInitialized = true;
            XmlUtils.processAnnotations(NinePatchInfo.class);
            XmlUtils.processAnnotations(NinePatchInterval.class);
            XmlUtils.processAnnotations(NinePatchIntervalType.class);
        }
    }

    public void openImage(File file) {
        try {
            if (this.imageSrc != null && file.getAbsolutePath().equals(this.imageSrc)) {
                return;
            }
            if (file.isDirectory() || !ImageUtils.isImageLoadable((String)file.getName())) {
                return;
            }
            Image image = Toolkit.getDefaultToolkit().createImage(file.getAbsolutePath());
            if (image == null) {
                return;
            }
            if (!this.continueAfterSave()) {
                return;
            }
            BufferedImage bi = ImageUtils.getBufferedImage((ImageIcon)new ImageIcon(image));
            this.ninePatchEditor.setNinePatchImage(bi);
            this.imageSrc = file.getAbsolutePath();
            this.save.setEnabled(true);
            this.openFromTreeEnabled = false;
            this.fileTree.setSelectedFile(file);
            this.fileTree.expandToFile(file, true, false, new Runnable(){

                @Override
                public void run() {
                    NinePatchEditorPanel.this.openFromTreeEnabled = true;
                }
            });
            this.fireStateChanged();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public boolean continueAfterSave() {
        if (this.ninePatchEditor.isChanged()) {
            String message = LanguageManager.get((String)"weblaf.ex.npeditor.saveChanges.text");
            String title = LanguageManager.get((String)"weblaf.ex.npeditor.saveChanges.title");
            boolean option = true;
            int messageType = 3;
            int confirm = WebOptionPane.showConfirmDialog(this, message, title, 1, 3);
            if (confirm == 0) {
                if (this.save.isEnabled()) {
                    this.save.doClick();
                } else {
                    this.saveAs.doClick();
                }
                if (this.ninePatchEditor.isChanged()) {
                    return false;
                }
            } else if (confirm == 2) {
                return false;
            }
        }
        return true;
    }

    private WebPanel createPreviewPanel() {
        boolean si = (Boolean)SettingsManager.get((String)"NinePatchEditor", (String)"preview.showIcon", (Object)false);
        boolean st = (Boolean)SettingsManager.get((String)"NinePatchEditor", (String)"preview.showText", (Object)true);
        Color foreground = (Color)SettingsManager.get((String)"NinePatchEditor", (String)"preview.foregroundColor", (Object)Color.WHITE);
        boolean da = (Boolean)SettingsManager.get((String)"NinePatchEditor", (String)"preview.transparentBackground", (Object)true);
        this.previewColor = (Color)SettingsManager.get((String)"NinePatchEditor", (String)"preview.backgroundColor", (Object)Color.WHITE);
        String defaultPreviewText = LanguageManager.get((String)"weblaf.ex.npeditor.preview.text");
        String previewText = (String)SettingsManager.get((String)"NinePatchEditor", (String)"preview.text", (Object)defaultPreviewText);
        double[] cols = new double[]{-1.0, -2.0, -1.0};
        double[] rows = new double[]{-2.0, -1.0, -2.0, -1.0};
        this.previewPanel = new WebPanel(this.previewBackgroundId, new TableLayout(new double[][]{cols, rows}), new Component[0]);
        this.previewPanel.setMinimumWidth(230);
        this.previewPanel.setPreferredHeight(400);
        if (!da) {
            this.previewPanel.setCustomPainter(new ColorPainter(this.previewColor));
        }
        this.preview = new WebLabel(0);
        this.preview.setIcon(si ? ICON : null);
        this.preview.setText(st ? this.parseToMultilineHtml(previewText) : "");
        this.preview.setForeground(foreground);
        this.updatePreview();
        this.getNinePatchEditor().addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                NinePatchEditorPanel.this.updatePreview();
            }
        });
        WebToolBar toolBar = new WebToolBar(StyleId.toolbarAttached, 0);
        final WebToggleButton showIcon = new WebToggleButton(SHOW_ICON_ICON);
        showIcon.setStyleId(StyleId.togglebuttonIconHover);
        showIcon.setLanguage("weblaf.ex.npeditor.preview.showIcon", new Object[0]);
        showIcon.setSelected(si);
        final WebToggleButton showText = new WebToggleButton(SHOW_TEXT_ICON);
        showText.setStyleId(StyleId.togglebuttonIconHover);
        showText.setLanguage("weblaf.ex.npeditor.preview.showText", new Object[0]);
        showText.setCursor(Cursor.getDefaultCursor());
        showText.setSelected(st);
        final WebTextField textField = new WebTextField(StyleId.ninepatcheditorPreviewField.at(this), previewText, 8);
        textField.setHorizontalAlignment(0);
        textField.setEditable(st);
        WebButton chooseColor = new WebButton(FOREGROUND_COLOR_ICON);
        chooseColor.setStyleId(StyleId.buttonIconHover);
        chooseColor.setLanguage("weblaf.ex.npeditor.preview.foregroundColor", new Object[0]);
        chooseColor.setCursor(Cursor.getDefaultCursor());
        GroupPane fieldGroup = new GroupPane(showText, textField, chooseColor);
        fieldGroup.setGroupButtons(false);
        WebToggleButton drawAlphaBackground = new WebToggleButton(TRANSPARENT_ICON);
        drawAlphaBackground.setLanguage("weblaf.ex.npeditor.preview.transparentBackground", new Object[0]);
        drawAlphaBackground.setSelected(da);
        final WebToggleButton drawColoredBackground = new WebToggleButton(ImageUtils.createColorIcon((Color)this.previewColor));
        drawColoredBackground.setLanguage("weblaf.ex.npeditor.preview.coloredBackground", new Object[0]);
        drawColoredBackground.setSelected(!da);
        showIcon.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                boolean show = showIcon.isSelected();
                SettingsManager.set((String)"NinePatchEditor", (String)"preview.showIcon", (Object)show);
                NinePatchEditorPanel.this.preview.setIcon(show ? ICON : null);
            }
        });
        showText.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                boolean show = showText.isSelected();
                SettingsManager.set((String)"NinePatchEditor", (String)"preview.showText", (Object)show);
                textField.setEditable(show);
                NinePatchEditorPanel.this.preview.setText(show ? NinePatchEditorPanel.this.parseToMultilineHtml(textField.getText()) : "");
            }
        });
        textField.addCaretListener(new CaretListener(){

            @Override
            public void caretUpdate(CaretEvent e) {
                SettingsManager.set((String)"NinePatchEditor", (String)"preview.text", (Object)textField.getText());
                NinePatchEditorPanel.this.preview.setText(showText.isSelected() ? NinePatchEditorPanel.this.parseToMultilineHtml(textField.getText()) : "");
            }
        });
        chooseColor.addActionListener(new ActionListener(){
            private WebColorChooserDialog webColorChooser = null;

            @Override
            public void actionPerformed(ActionEvent e) {
                if (this.webColorChooser == null) {
                    this.webColorChooser = new WebColorChooserDialog((Component)SwingUtils.getWindowAncestor((Component)NinePatchEditorPanel.this.previewPanel));
                }
                this.webColorChooser.setColor(NinePatchEditorPanel.this.preview.getForeground());
                if (this.webColorChooser.showDialog() == 0) {
                    Color color = this.webColorChooser.getColor();
                    SettingsManager.set((String)"NinePatchEditor", (String)"preview.foregroundColor", (Object)color);
                    NinePatchEditorPanel.this.preview.setForeground(color);
                }
            }
        });
        drawAlphaBackground.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SettingsManager.set((String)"NinePatchEditor", (String)"preview.transparentBackground", (Object)true);
                NinePatchEditorPanel.this.previewPanel.restoreDefaultPainters();
            }
        });
        drawColoredBackground.addActionListener(new ActionListener(){
            private WebColorChooserDialog webColorChooser = null;

            @Override
            public void actionPerformed(ActionEvent e) {
                SettingsManager.set((String)"NinePatchEditor", (String)"preview.transparentBackground", (Object)false);
                if (this.webColorChooser == null) {
                    this.webColorChooser = new WebColorChooserDialog((Component)SwingUtils.getWindowAncestor((Component)NinePatchEditorPanel.this.previewPanel));
                }
                this.webColorChooser.setColor(NinePatchEditorPanel.this.previewColor);
                if (this.webColorChooser.showDialog() == 0) {
                    Color color = this.webColorChooser.getColor();
                    SettingsManager.set((String)"NinePatchEditor", (String)"preview.backgroundColor", (Object)color);
                    drawColoredBackground.setIcon(ImageUtils.createColorIcon((Color)color));
                    NinePatchEditorPanel.this.previewColor = color;
                }
                NinePatchEditorPanel.this.previewPanel.setCustomPainter(new ColorPainter(NinePatchEditorPanel.this.previewColor));
            }
        });
        toolBar.add((Component)showIcon);
        toolBar.addFill(fieldGroup);
        toolBar.addToEnd(new GroupPane(drawAlphaBackground, drawColoredBackground));
        this.previewPanel.add((Component)toolBar, (Object)"0,0,2,0");
        this.previewPanel.add((Component)new ResizablePanel(this.preview), (Object)"1,2");
        return this.previewPanel;
    }

    private String parseToMultilineHtml(String text) {
        return "<html><center>" + text.replaceAll(";", "<br>").replaceAll("\\\\n", "<br>") + "</center></html>";
    }

    private void updatePreview() {
        this.preview.setCustomPainter(new NPLabelPainter(this.getNinePatchEditor().getNinePatchIcon()));
        this.preview.setForeground((Color)SettingsManager.get((String)"NinePatchEditor", (String)"preview.foregroundColor", (Object)Color.WHITE));
        this.previewPanel.revalidate();
    }

    private void saveImage(File imageFile) throws IOException {
        String fullName = this.getSaveFileName(imageFile);
        imageFile = new File(imageFile.getParent(), fullName);
        this.imageSrc = imageFile.getAbsolutePath();
        BufferedImage image = this.ninePatchEditor.getNinePatchImage();
        ImageIO.write((RenderedImage)image, "png", imageFile);
        this.ninePatchEditor.setChanged(false);
        this.fireStateChanged();
    }

    private String getSaveFileName(File imageFile) {
        String format = ".png";
        String subFormat = ".9";
        String fullName = imageFile.getName();
        if (fullName.endsWith(".png")) {
            String name = fullName.substring(0, fullName.lastIndexOf(".png"));
            if (!name.endsWith(".9")) {
                fullName = name + ".9" + ".png";
            }
        } else if (fullName.endsWith(".9")) {
            fullName = fullName + ".png";
        } else {
            int dot = fullName.lastIndexOf("");
            if (dot != -1) {
                fullName = fullName.substring(0, dot);
            }
            fullName = fullName + ".9" + ".png";
        }
        return fullName;
    }

    public NinePatchEditor getNinePatchEditor() {
        return this.ninePatchEditor;
    }

    public String getImageSrc() {
        return this.imageSrc;
    }

    public void setNinePatchImage(ImageIcon imageIcon) {
        this.setNinePatchImage(imageIcon.getImage());
    }

    public void setNinePatchImage(Image image) {
        this.setNinePatchImage(ImageUtils.getBufferedImage((Image)image));
    }

    public void setNinePatchImage(BufferedImage ninePatchImage) {
        if (!this.continueAfterSave()) {
            return;
        }
        this.ninePatchEditor.setNinePatchImage(ninePatchImage);
        this.imageSrc = null;
        this.save.setEnabled(true);
        this.fireStateChanged();
    }

    public BufferedImage getNinePatchImage() {
        return this.ninePatchEditor.getNinePatchImage();
    }

    public void setSelectedDirectory(File file) {
        this.fileTree.setSelectedFile(file, true);
    }

    public List<ChangeListener> getChangeListeners() {
        return this.changeListeners;
    }

    public void addChangeListener(ChangeListener changeListener) {
        this.changeListeners.add(changeListener);
    }

    public void removeChangeListener(ChangeListener changeListener) {
        this.changeListeners.add(changeListener);
    }

    private void fireStateChanged() {
        ChangeEvent changeEvent = new ChangeEvent(this);
        for (ChangeListener listener : CollectionUtils.copy(this.changeListeners)) {
            listener.stateChanged(changeEvent);
        }
    }
}

