/*
 * Decompiled with CFR 0.152.
 */
package com.alee.extended.list;

import com.alee.extended.list.CheckBoxCellData;
import com.alee.extended.list.CheckBoxListModel;
import com.alee.extended.list.WebCheckBoxListCellEditor;
import com.alee.extended.list.WebCheckBoxListCellRenderer;
import com.alee.extended.list.WebCheckBoxListElement;
import com.alee.laf.list.WebList;
import com.alee.laf.list.editor.ListCellEditor;
import com.alee.managers.hotkey.Hotkey;
import com.alee.managers.style.StyleId;
import java.awt.Rectangle;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.List;
import javax.swing.ListCellRenderer;

public class WebCheckBoxList
extends WebList {
    protected boolean checkOnIconOnly = true;

    public WebCheckBoxList() {
        this(StyleId.checkboxlist, new CheckBoxListModel());
    }

    public WebCheckBoxList(CheckBoxListModel model) {
        this(StyleId.checkboxlist, model);
    }

    public WebCheckBoxList(StyleId id) {
        this(id, new CheckBoxListModel());
    }

    public WebCheckBoxList(StyleId id, CheckBoxListModel model) {
        super(id, model);
        this.setCellRenderer(new WebCheckBoxListCellRenderer());
        this.addMouseListener(new CheckBoxListMouseAdapter());
        this.addKeyListener(new CheckBoxListKeyAdapter());
    }

    public WebCheckBoxListCellRenderer getWebCheckBoxListCellRenderer() {
        ListCellRenderer renderer = this.getCellRenderer();
        return renderer instanceof WebCheckBoxListCellRenderer ? (WebCheckBoxListCellRenderer)renderer : null;
    }

    public CheckBoxListModel getCheckBoxListModel() {
        return (CheckBoxListModel)this.getModel();
    }

    @Override
    protected ListCellEditor createDefaultCellEditor() {
        return new WebCheckBoxListCellEditor();
    }

    public boolean isCheckBoxSelected(int index) {
        return this.getCheckBoxListModel().isCheckBoxSelected(index);
    }

    public void invertCheckBoxSelection(int index) {
        this.getCheckBoxListModel().invertCheckBoxSelection(index);
        this.performAnimation(index);
    }

    public void setCheckBoxSelected(int index, boolean selected) {
        if (this.getCheckBoxListModel().setCheckBoxSelected(index, selected)) {
            this.performAnimation(index);
        }
    }

    public List<Object> getCheckedValues() {
        return this.getCheckBoxListModel().getCheckedValues();
    }

    protected void performAnimation(int index) {
    }

    public boolean isCheckOnIconOnly() {
        return this.checkOnIconOnly;
    }

    public void setCheckOnIconOnly(boolean checkOnIconOnly) {
        this.checkOnIconOnly = checkOnIconOnly;
    }

    protected class CheckBoxListKeyAdapter
    extends KeyAdapter {
        protected CheckBoxListKeyAdapter() {
        }

        @Override
        public void keyReleased(KeyEvent e) {
            if (Hotkey.SPACE.isTriggered(e) && WebCheckBoxList.this.getSelectedIndex() != -1 && WebCheckBoxList.this.isEnabled()) {
                for (int index : WebCheckBoxList.this.getSelectedIndices()) {
                    WebCheckBoxList.this.invertCheckBoxSelection(index);
                }
            }
        }
    }

    protected class CheckBoxListMouseAdapter
    extends MouseAdapter {
        protected CheckBoxListMouseAdapter() {
        }

        @Override
        public void mousePressed(MouseEvent e) {
            WebCheckBoxList list = WebCheckBoxList.this;
            int index = WebCheckBoxList.this.getUI().locationToIndex(list, e.getPoint());
            if (index != -1 && list.isEnabled()) {
                if (WebCheckBoxList.this.checkOnIconOnly) {
                    WebCheckBoxListCellRenderer renderer = WebCheckBoxList.this.getWebCheckBoxListCellRenderer();
                    WebCheckBoxListElement element = renderer.getElement(list, (CheckBoxCellData)WebCheckBoxList.this.getCheckBoxListModel().get(index));
                    Rectangle cellRect = WebCheckBoxList.this.getWebUI().getCellBounds(list, index, index);
                    Rectangle iconRect = element.getWebUI().getIconRect();
                    iconRect.x += cellRect.x;
                    iconRect.y += cellRect.y;
                    if (iconRect.contains(e.getPoint())) {
                        WebCheckBoxList.this.invertCheckBoxSelection(index);
                    }
                } else {
                    WebCheckBoxList.this.invertCheckBoxSelection(index);
                }
            }
        }
    }
}

