/*
 * Decompiled with CFR 0.152.
 */
package com.alee.extended.label;

import com.alee.extended.label.AdaptiveStyledLabelPainter;
import com.alee.extended.label.IStyledLabelPainter;
import com.alee.extended.label.StyledLabelPainter;
import com.alee.extended.label.WebStyledLabel;
import com.alee.managers.style.Bounds;
import com.alee.managers.style.MarginSupport;
import com.alee.managers.style.PaddingSupport;
import com.alee.managers.style.ShapeProvider;
import com.alee.managers.style.StyleId;
import com.alee.managers.style.StyleManager;
import com.alee.managers.style.Styleable;
import com.alee.painter.DefaultPainter;
import com.alee.painter.Painter;
import com.alee.painter.PainterSupport;
import com.alee.utils.swing.DataRunnable;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Shape;
import java.beans.PropertyChangeEvent;
import javax.swing.JComponent;
import javax.swing.SwingConstants;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicLabelUI;

public class WebStyledLabelUI
extends BasicLabelUI
implements Styleable,
ShapeProvider,
MarginSupport,
PaddingSupport,
SwingConstants {
    @DefaultPainter(value=StyledLabelPainter.class)
    protected IStyledLabelPainter painter;
    protected WebStyledLabel label;
    protected Insets margin = null;
    protected Insets padding = null;

    public static ComponentUI createUI(JComponent c) {
        return new WebStyledLabelUI();
    }

    @Override
    public void installUI(JComponent c) {
        super.installUI(c);
        this.label = (WebStyledLabel)c;
        StyleManager.installSkin(this.label);
    }

    @Override
    public void uninstallUI(JComponent c) {
        StyleManager.uninstallSkin(this.label);
        this.label = null;
        super.uninstallUI(c);
    }

    @Override
    public void propertyChange(PropertyChangeEvent e) {
        super.propertyChange(e);
        if ("styleRange".equals(e.getPropertyName()) && this.painter != null) {
            this.painter.updateTextRanges();
        }
    }

    @Override
    public StyleId getStyleId() {
        return StyleManager.getStyleId(this.label);
    }

    @Override
    public StyleId setStyleId(StyleId id) {
        return StyleManager.setStyleId(this.label, id);
    }

    @Override
    public Shape provideShape() {
        return PainterSupport.getShape(this.label, this.painter);
    }

    @Override
    public Insets getMargin() {
        return this.margin;
    }

    @Override
    public void setMargin(Insets margin) {
        this.margin = margin;
        PainterSupport.updateBorder(this.getPainter());
    }

    @Override
    public Insets getPadding() {
        return this.padding;
    }

    @Override
    public void setPadding(Insets padding) {
        this.padding = padding;
        PainterSupport.updateBorder(this.getPainter());
    }

    public Painter getPainter() {
        return PainterSupport.getAdaptedPainter(this.painter);
    }

    public void setPainter(Painter painter) {
        PainterSupport.setPainter(this.label, new DataRunnable<IStyledLabelPainter>(){

            public void run(IStyledLabelPainter newPainter) {
                WebStyledLabelUI.this.painter = newPainter;
            }
        }, this.painter, painter, IStyledLabelPainter.class, AdaptiveStyledLabelPainter.class);
    }

    @Override
    public void paint(Graphics g, JComponent c) {
        if (this.painter != null) {
            this.painter.paint((Graphics2D)g, Bounds.component.of(c), c, this);
        }
    }

    @Override
    public Dimension getPreferredSize(JComponent c) {
        return PainterSupport.getPreferredSize(c, this.painter);
    }
}

