/*
 * Decompiled with CFR 0.152.
 */
package com.alee.extended.button;

import com.alee.extended.button.SplitButtonListener;
import com.alee.extended.button.WebSplitButtonUI;
import com.alee.laf.WebLookAndFeel;
import com.alee.laf.menu.PopupMenuWay;
import com.alee.laf.menu.WebPopupMenuUI;
import com.alee.managers.hotkey.HotkeyData;
import com.alee.managers.language.LanguageManager;
import com.alee.managers.language.LanguageMethods;
import com.alee.managers.language.LanguageUtils;
import com.alee.managers.language.data.TooltipWay;
import com.alee.managers.language.updaters.LanguageUpdater;
import com.alee.managers.log.Log;
import com.alee.managers.style.MarginSupport;
import com.alee.managers.style.PaddingSupport;
import com.alee.managers.style.ShapeProvider;
import com.alee.managers.style.Skin;
import com.alee.managers.style.Skinnable;
import com.alee.managers.style.StyleId;
import com.alee.managers.style.StyleListener;
import com.alee.managers.style.StyleManager;
import com.alee.managers.style.Styleable;
import com.alee.managers.style.StyleableComponent;
import com.alee.managers.tooltip.ToolTipMethods;
import com.alee.managers.tooltip.TooltipManager;
import com.alee.managers.tooltip.WebCustomTooltip;
import com.alee.painter.Paintable;
import com.alee.painter.Painter;
import com.alee.utils.EventUtils;
import com.alee.utils.ReflectUtils;
import com.alee.utils.SizeUtils;
import com.alee.utils.SwingUtils;
import com.alee.utils.swing.EventMethods;
import com.alee.utils.swing.FocusEventRunnable;
import com.alee.utils.swing.FontMethods;
import com.alee.utils.swing.KeyEventRunnable;
import com.alee.utils.swing.MouseButton;
import com.alee.utils.swing.MouseEventRunnable;
import com.alee.utils.swing.SizeMethods;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.Shape;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.KeyAdapter;
import java.awt.event.MouseAdapter;
import java.util.List;
import java.util.Map;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JPopupMenu;

public class WebSplitButton
extends JButton
implements ActionListener,
Styleable,
Skinnable,
Paintable,
ShapeProvider,
MarginSupport,
PaddingSupport,
EventMethods,
ToolTipMethods,
LanguageMethods,
FontMethods<WebSplitButton>,
SizeMethods<WebSplitButton> {
    public static final ImageIcon defaultSplitIcon = new ImageIcon(WebSplitButton.class.getResource("icons/splitIcon.png"));
    public static final String SPLIT_ICON_PROPERTY = "splitIcon";
    protected boolean alwaysShowMenu = false;
    protected PopupMenuWay popupMenuWay = PopupMenuWay.belowStart;
    protected JPopupMenu popupMenu;
    protected Icon splitIcon;

    public WebSplitButton() {
    }

    public WebSplitButton(Icon icon) {
        super(icon);
        this.setStyleId(StyleId.splitbuttonIcon);
    }

    public WebSplitButton(Icon icon, Icon rolloverIcon) {
        super(icon);
        this.setRolloverIcon(rolloverIcon);
        this.setStyleId(StyleId.splitbuttonIcon);
    }

    public WebSplitButton(String text) {
        super(text);
    }

    public WebSplitButton(String text, Icon icon) {
        super(text, icon);
    }

    public WebSplitButton(ActionListener listener) {
        this.addActionListener(listener);
    }

    public WebSplitButton(Icon icon, ActionListener listener) {
        super(icon);
        this.setStyleId(StyleId.splitbuttonIcon);
        this.addActionListener(listener);
    }

    public WebSplitButton(String text, ActionListener listener) {
        super(text);
        this.addActionListener(listener);
    }

    public WebSplitButton(String text, Icon icon, ActionListener listener) {
        super(text, icon);
        this.addActionListener(listener);
    }

    public WebSplitButton(Action action) {
        super(action);
    }

    public WebSplitButton(StyleId id) {
        this.setStyleId(id);
    }

    public WebSplitButton(StyleId id, Icon icon) {
        super(icon);
        this.setStyleId(id);
    }

    public WebSplitButton(StyleId id, String text) {
        super(text);
        this.setStyleId(id);
    }

    public WebSplitButton(StyleId id, String text, Icon icon) {
        super(text, icon);
        this.setStyleId(id);
    }

    public WebSplitButton(StyleId id, Icon icon, Icon rolloverIcon) {
        super(icon);
        this.setRolloverIcon(rolloverIcon);
        this.setStyleId(id);
    }

    public WebSplitButton(StyleId id, ActionListener listener) {
        this.setStyleId(id);
        this.addActionListener(listener);
    }

    public WebSplitButton(StyleId id, Icon icon, ActionListener listener) {
        super(icon);
        this.setStyleId(id);
        this.addActionListener(listener);
    }

    public WebSplitButton(StyleId id, String text, ActionListener listener) {
        super(text);
        this.setStyleId(id);
        this.addActionListener(listener);
    }

    public WebSplitButton(StyleId id, String text, Icon icon, ActionListener listener) {
        super(text, icon);
        this.addActionListener(listener);
        this.setStyleId(id);
    }

    public WebSplitButton(StyleId id, Action action) {
        super(action);
        this.setStyleId(id);
    }

    @Override
    protected void init(String text, Icon icon) {
        super.init(LanguageUtils.getInitialText((String)text, (Object[])new Object[0]), icon);
        LanguageUtils.registerInitialLanguage((LanguageMethods)this, (String)text, (Object[])new Object[0]);
        this.addActionListener(this);
    }

    @Override
    public StyleId getStyleId() {
        return this.getWebUI().getStyleId();
    }

    @Override
    public StyleId setStyleId(StyleId id) {
        return this.getWebUI().setStyleId(id);
    }

    @Override
    public Skin getSkin() {
        return StyleManager.getSkin(this);
    }

    @Override
    public Skin setSkin(Skin skin) {
        return StyleManager.setSkin(this, skin);
    }

    @Override
    public Skin setSkin(Skin skin, boolean recursively) {
        return StyleManager.setSkin(this, skin, recursively);
    }

    @Override
    public Skin restoreSkin() {
        return StyleManager.restoreSkin(this);
    }

    @Override
    public void addStyleListener(StyleListener listener) {
        StyleManager.addStyleListener(this, listener);
    }

    @Override
    public void removeStyleListener(StyleListener listener) {
        StyleManager.removeStyleListener(this, listener);
    }

    @Override
    public Map<String, Painter> getCustomPainters() {
        return StyleManager.getCustomPainters(this);
    }

    @Override
    public Painter getCustomPainter() {
        return StyleManager.getCustomPainter(this);
    }

    @Override
    public Painter getCustomPainter(String id) {
        return StyleManager.getCustomPainter(this, id);
    }

    @Override
    public Painter setCustomPainter(Painter painter) {
        return StyleManager.setCustomPainter(this, painter);
    }

    @Override
    public Painter setCustomPainter(String id, Painter painter) {
        return StyleManager.setCustomPainter(this, id, painter);
    }

    @Override
    public boolean restoreDefaultPainters() {
        return StyleManager.restoreDefaultPainters(this);
    }

    @Override
    public Shape provideShape() {
        return this.getWebUI().provideShape();
    }

    @Override
    public Insets getMargin() {
        return this.getWebUI().getMargin();
    }

    public void setMargin(int margin) {
        this.setMargin(margin, margin, margin, margin);
    }

    public void setMargin(int top, int left, int bottom, int right) {
        this.setMargin(new Insets(top, left, bottom, right));
    }

    @Override
    public void setMargin(Insets margin) {
        this.getWebUI().setMargin(margin);
    }

    @Override
    public Insets getPadding() {
        return this.getWebUI().getPadding();
    }

    public void setPadding(int padding) {
        this.setPadding(padding, padding, padding, padding);
    }

    public void setPadding(int top, int left, int bottom, int right) {
        this.setPadding(new Insets(top, left, bottom, right));
    }

    @Override
    public void setPadding(Insets padding) {
        this.getWebUI().setPadding(padding);
    }

    public JPopupMenu getPopupMenu() {
        return this.popupMenu;
    }

    public void setPopupMenu(JPopupMenu popupMenu) {
        this.popupMenu = popupMenu;
    }

    public boolean isAlwaysShowMenu() {
        return this.alwaysShowMenu;
    }

    public void setAlwaysShowMenu(boolean alwaysShowMenu) {
        this.alwaysShowMenu = alwaysShowMenu;
    }

    public PopupMenuWay getPopupMenuWay() {
        return this.popupMenuWay;
    }

    public void setPopupMenuWay(PopupMenuWay way) {
        this.popupMenuWay = way;
    }

    public Icon getSplitIcon() {
        return this.splitIcon != null ? this.splitIcon : defaultSplitIcon;
    }

    public void setSplitIcon(Icon splitIcon) {
        Icon oldIcon = this.splitIcon;
        this.splitIcon = splitIcon;
        this.firePropertyChange(SPLIT_ICON_PROPERTY, oldIcon, splitIcon);
    }

    public void addSplitButtonListener(SplitButtonListener listener) {
        this.listenerList.add(SplitButtonListener.class, listener);
    }

    public void removeSplitButtonListener(SplitButtonListener listener) {
        if (listener != null && this.getAction() == listener) {
            this.setAction(null);
        } else {
            this.listenerList.remove(SplitButtonListener.class, listener);
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (this.getWebUI().isOnSplit()) {
            this.showPopupMenu();
            this.fireSplitbuttonClicked(e);
        } else {
            if (this.isAlwaysShowMenu()) {
                this.showPopupMenu();
            }
            this.fireButtonClicked(e);
        }
    }

    public void showPopupMenu() {
        if (this.popupMenu != null) {
            if (this.popupMenu.getUI() instanceof WebPopupMenuUI) {
                ((WebPopupMenuUI)this.popupMenu.getUI()).setPopupMenuWay(this.popupMenuWay);
            }
            if (this.getComponentOrientation().isLeftToRight()) {
                this.popupMenu.show(this, 0, this.getHeight());
            } else {
                this.popupMenu.show(this, this.getWidth() - this.popupMenu.getPreferredSize().width, this.getHeight());
            }
        }
    }

    protected void fireButtonClicked(ActionEvent event) {
        Object[] listeners = this.listenerList.getListenerList();
        ActionEvent e = null;
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != SplitButtonListener.class) continue;
            if (e == null) {
                String actionCommand = event.getActionCommand();
                if (actionCommand == null) {
                    actionCommand = this.getActionCommand();
                }
                e = new ActionEvent(this, 1001, actionCommand, event.getWhen(), event.getModifiers());
            }
            ((SplitButtonListener)listeners[i + 1]).buttonClicked(e);
        }
    }

    protected void fireSplitbuttonClicked(ActionEvent event) {
        Object[] listeners = this.listenerList.getListenerList();
        ActionEvent e = null;
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != SplitButtonListener.class) continue;
            if (e == null) {
                String actionCommand = event.getActionCommand();
                if (actionCommand == null) {
                    actionCommand = this.getActionCommand();
                }
                e = new ActionEvent(this, 1001, actionCommand, event.getWhen(), event.getModifiers());
            }
            ((SplitButtonListener)listeners[i + 1]).splitButtonClicked(e);
        }
    }

    private WebSplitButtonUI getWebUI() {
        return (WebSplitButtonUI)this.getUI();
    }

    @Override
    public void updateUI() {
        if (this.getUI() == null || !(this.getUI() instanceof WebSplitButtonUI)) {
            try {
                this.setUI((WebSplitButtonUI)ReflectUtils.createInstance((String)WebLookAndFeel.splitButtonUI, (Object[])new Object[0]));
            }
            catch (Throwable e) {
                Log.error((Object)this, (Throwable)e);
                this.setUI(new WebSplitButtonUI());
            }
        } else {
            this.setUI(this.getUI());
        }
    }

    @Override
    public String getUIClassID() {
        return StyleableComponent.splitbutton.getUIClassID();
    }

    @Override
    public MouseAdapter onMousePress(MouseEventRunnable runnable) {
        return EventUtils.onMousePress(this, runnable);
    }

    @Override
    public MouseAdapter onMousePress(MouseButton mouseButton, MouseEventRunnable runnable) {
        return EventUtils.onMousePress(this, mouseButton, runnable);
    }

    @Override
    public MouseAdapter onMouseEnter(MouseEventRunnable runnable) {
        return EventUtils.onMouseEnter(this, runnable);
    }

    @Override
    public MouseAdapter onMouseExit(MouseEventRunnable runnable) {
        return EventUtils.onMouseExit(this, runnable);
    }

    @Override
    public MouseAdapter onMouseDrag(MouseEventRunnable runnable) {
        return EventUtils.onMouseDrag(this, runnable);
    }

    @Override
    public MouseAdapter onMouseDrag(MouseButton mouseButton, MouseEventRunnable runnable) {
        return EventUtils.onMouseDrag(this, mouseButton, runnable);
    }

    @Override
    public MouseAdapter onMouseClick(MouseEventRunnable runnable) {
        return EventUtils.onMouseClick(this, runnable);
    }

    @Override
    public MouseAdapter onMouseClick(MouseButton mouseButton, MouseEventRunnable runnable) {
        return EventUtils.onMouseClick(this, mouseButton, runnable);
    }

    @Override
    public MouseAdapter onDoubleClick(MouseEventRunnable runnable) {
        return EventUtils.onDoubleClick(this, runnable);
    }

    @Override
    public MouseAdapter onMenuTrigger(MouseEventRunnable runnable) {
        return EventUtils.onMenuTrigger(this, runnable);
    }

    @Override
    public KeyAdapter onKeyType(KeyEventRunnable runnable) {
        return EventUtils.onKeyType(this, runnable);
    }

    @Override
    public KeyAdapter onKeyType(HotkeyData hotkey, KeyEventRunnable runnable) {
        return EventUtils.onKeyType(this, hotkey, runnable);
    }

    @Override
    public KeyAdapter onKeyPress(KeyEventRunnable runnable) {
        return EventUtils.onKeyPress(this, runnable);
    }

    @Override
    public KeyAdapter onKeyPress(HotkeyData hotkey, KeyEventRunnable runnable) {
        return EventUtils.onKeyPress(this, hotkey, runnable);
    }

    @Override
    public KeyAdapter onKeyRelease(KeyEventRunnable runnable) {
        return EventUtils.onKeyRelease(this, runnable);
    }

    @Override
    public KeyAdapter onKeyRelease(HotkeyData hotkey, KeyEventRunnable runnable) {
        return EventUtils.onKeyRelease(this, hotkey, runnable);
    }

    @Override
    public FocusAdapter onFocusGain(FocusEventRunnable runnable) {
        return EventUtils.onFocusGain(this, runnable);
    }

    @Override
    public FocusAdapter onFocusLoss(FocusEventRunnable runnable) {
        return EventUtils.onFocusLoss(this, runnable);
    }

    @Override
    public WebCustomTooltip setToolTip(String tooltip) {
        return TooltipManager.setTooltip((Component)this, tooltip);
    }

    @Override
    public WebCustomTooltip setToolTip(Icon icon, String tooltip) {
        return TooltipManager.setTooltip((Component)this, icon, tooltip);
    }

    @Override
    public WebCustomTooltip setToolTip(String tooltip, TooltipWay tooltipWay) {
        return TooltipManager.setTooltip((Component)this, tooltip, tooltipWay);
    }

    @Override
    public WebCustomTooltip setToolTip(Icon icon, String tooltip, TooltipWay tooltipWay) {
        return TooltipManager.setTooltip((Component)this, icon, tooltip, tooltipWay);
    }

    @Override
    public WebCustomTooltip setToolTip(String tooltip, TooltipWay tooltipWay, int delay) {
        return TooltipManager.setTooltip((Component)this, tooltip, tooltipWay, delay);
    }

    @Override
    public WebCustomTooltip setToolTip(Icon icon, String tooltip, TooltipWay tooltipWay, int delay) {
        return TooltipManager.setTooltip(this, icon, tooltip, tooltipWay, delay);
    }

    @Override
    public WebCustomTooltip setToolTip(JComponent tooltip) {
        return TooltipManager.setTooltip((Component)this, tooltip);
    }

    @Override
    public WebCustomTooltip setToolTip(JComponent tooltip, int delay) {
        return TooltipManager.setTooltip((Component)this, tooltip, delay);
    }

    @Override
    public WebCustomTooltip setToolTip(JComponent tooltip, TooltipWay tooltipWay) {
        return TooltipManager.setTooltip((Component)this, tooltip, tooltipWay);
    }

    @Override
    public WebCustomTooltip setToolTip(JComponent tooltip, TooltipWay tooltipWay, int delay) {
        return TooltipManager.setTooltip((Component)this, tooltip, tooltipWay, delay);
    }

    @Override
    public WebCustomTooltip addToolTip(String tooltip) {
        return TooltipManager.addTooltip((Component)this, tooltip);
    }

    @Override
    public WebCustomTooltip addToolTip(Icon icon, String tooltip) {
        return TooltipManager.addTooltip((Component)this, icon, tooltip);
    }

    @Override
    public WebCustomTooltip addToolTip(String tooltip, TooltipWay tooltipWay) {
        return TooltipManager.addTooltip((Component)this, tooltip, tooltipWay);
    }

    @Override
    public WebCustomTooltip addToolTip(Icon icon, String tooltip, TooltipWay tooltipWay) {
        return TooltipManager.addTooltip((Component)this, icon, tooltip, tooltipWay);
    }

    @Override
    public WebCustomTooltip addToolTip(String tooltip, TooltipWay tooltipWay, int delay) {
        return TooltipManager.addTooltip((Component)this, tooltip, tooltipWay, delay);
    }

    @Override
    public WebCustomTooltip addToolTip(Icon icon, String tooltip, TooltipWay tooltipWay, int delay) {
        return TooltipManager.addTooltip((Component)this, icon, tooltip, tooltipWay, delay);
    }

    @Override
    public WebCustomTooltip addToolTip(JComponent tooltip) {
        return TooltipManager.addTooltip((Component)this, tooltip);
    }

    @Override
    public WebCustomTooltip addToolTip(JComponent tooltip, int delay) {
        return TooltipManager.addTooltip((Component)this, tooltip, delay);
    }

    @Override
    public WebCustomTooltip addToolTip(JComponent tooltip, TooltipWay tooltipWay) {
        return TooltipManager.addTooltip((Component)this, tooltip, tooltipWay);
    }

    @Override
    public WebCustomTooltip addToolTip(JComponent tooltip, TooltipWay tooltipWay, int delay) {
        return TooltipManager.addTooltip((Component)this, tooltip, tooltipWay, delay);
    }

    @Override
    public void removeToolTip(WebCustomTooltip tooltip) {
        TooltipManager.removeTooltip(this, tooltip);
    }

    @Override
    public void removeToolTips() {
        TooltipManager.removeTooltips(this);
    }

    @Override
    public void removeToolTips(WebCustomTooltip ... tooltips) {
        TooltipManager.removeTooltips((Component)this, tooltips);
    }

    @Override
    public void removeToolTips(List<WebCustomTooltip> tooltips) {
        TooltipManager.removeTooltips((Component)this, tooltips);
    }

    public void setLanguage(String key, Object ... data) {
        LanguageManager.registerComponent((JComponent)this, (String)key, (Object[])data);
    }

    public void updateLanguage(Object ... data) {
        LanguageManager.updateComponent((JComponent)this, (Object[])data);
    }

    public void updateLanguage(String key, Object ... data) {
        LanguageManager.updateComponent((JComponent)this, (String)key, (Object[])data);
    }

    public void removeLanguage() {
        LanguageManager.unregisterComponent((JComponent)this);
    }

    public boolean isLanguageSet() {
        return LanguageManager.isRegisteredComponent((JComponent)this);
    }

    public void setLanguageUpdater(LanguageUpdater updater) {
        LanguageManager.registerLanguageUpdater((JComponent)this, (LanguageUpdater)updater);
    }

    public void removeLanguageUpdater() {
        LanguageManager.unregisterLanguageUpdater((JComponent)this);
    }

    @Override
    public WebSplitButton setPlainFont() {
        return SwingUtils.setPlainFont(this);
    }

    @Override
    public WebSplitButton setPlainFont(boolean apply) {
        return SwingUtils.setPlainFont(this, apply);
    }

    @Override
    public boolean isPlainFont() {
        return SwingUtils.isPlainFont(this);
    }

    @Override
    public WebSplitButton setBoldFont() {
        return SwingUtils.setBoldFont(this);
    }

    @Override
    public WebSplitButton setBoldFont(boolean apply) {
        return SwingUtils.setBoldFont(this, apply);
    }

    @Override
    public boolean isBoldFont() {
        return SwingUtils.isBoldFont(this);
    }

    @Override
    public WebSplitButton setItalicFont() {
        return SwingUtils.setItalicFont(this);
    }

    @Override
    public WebSplitButton setItalicFont(boolean apply) {
        return SwingUtils.setItalicFont(this, apply);
    }

    @Override
    public boolean isItalicFont() {
        return SwingUtils.isItalicFont(this);
    }

    @Override
    public WebSplitButton setFontStyle(boolean bold, boolean italic) {
        return SwingUtils.setFontStyle(this, bold, italic);
    }

    @Override
    public WebSplitButton setFontStyle(int style) {
        return SwingUtils.setFontStyle(this, style);
    }

    @Override
    public WebSplitButton setFontSize(int fontSize) {
        return SwingUtils.setFontSize(this, fontSize);
    }

    @Override
    public WebSplitButton changeFontSize(int change) {
        return SwingUtils.changeFontSize(this, change);
    }

    @Override
    public int getFontSize() {
        return SwingUtils.getFontSize(this);
    }

    @Override
    public WebSplitButton setFontSizeAndStyle(int fontSize, boolean bold, boolean italic) {
        return SwingUtils.setFontSizeAndStyle(this, fontSize, bold, italic);
    }

    @Override
    public WebSplitButton setFontSizeAndStyle(int fontSize, int style) {
        return SwingUtils.setFontSizeAndStyle(this, fontSize, style);
    }

    @Override
    public WebSplitButton setFontName(String fontName) {
        return SwingUtils.setFontName(this, fontName);
    }

    @Override
    public String getFontName() {
        return SwingUtils.getFontName(this);
    }

    @Override
    public int getPreferredWidth() {
        return SizeUtils.getPreferredWidth(this);
    }

    @Override
    public WebSplitButton setPreferredWidth(int preferredWidth) {
        return SizeUtils.setPreferredWidth(this, preferredWidth);
    }

    @Override
    public int getPreferredHeight() {
        return SizeUtils.getPreferredHeight(this);
    }

    @Override
    public WebSplitButton setPreferredHeight(int preferredHeight) {
        return SizeUtils.setPreferredHeight(this, preferredHeight);
    }

    @Override
    public int getMinimumWidth() {
        return SizeUtils.getMinimumWidth(this);
    }

    @Override
    public WebSplitButton setMinimumWidth(int minimumWidth) {
        return SizeUtils.setMinimumWidth(this, minimumWidth);
    }

    @Override
    public int getMinimumHeight() {
        return SizeUtils.getMinimumHeight(this);
    }

    @Override
    public WebSplitButton setMinimumHeight(int minimumHeight) {
        return SizeUtils.setMinimumHeight(this, minimumHeight);
    }

    @Override
    public int getMaximumWidth() {
        return SizeUtils.getMaximumWidth(this);
    }

    @Override
    public WebSplitButton setMaximumWidth(int maximumWidth) {
        return SizeUtils.setMaximumWidth(this, maximumWidth);
    }

    @Override
    public int getMaximumHeight() {
        return SizeUtils.getMaximumHeight(this);
    }

    @Override
    public WebSplitButton setMaximumHeight(int maximumHeight) {
        return SizeUtils.setMaximumHeight(this, maximumHeight);
    }

    @Override
    public Dimension getPreferredSize() {
        return SizeUtils.getPreferredSize(this, super.getPreferredSize());
    }

    @Override
    public WebSplitButton setPreferredSize(int width, int height) {
        return SizeUtils.setPreferredSize(this, width, height);
    }
}

