/*
 * Decompiled with CFR 0.152.
 */
package com.alee.utils.xml;

import com.alee.managers.log.Log;
import com.alee.utils.TextUtils;
import com.thoughtworks.xstream.converters.basic.AbstractSingleValueConverter;
import java.awt.geom.Point2D;
import java.util.List;

public class Point2DConverter
extends AbstractSingleValueConverter {
    public boolean canConvert(Class type) {
        return Point2D.class.isAssignableFrom(type);
    }

    public Object fromString(String str) {
        return Point2DConverter.pointFromString(str);
    }

    public String toString(Object obj) {
        return Point2DConverter.pointToString((Point2D)obj);
    }

    public static Point2D.Float pointFromString(String point) {
        try {
            List<String> points = TextUtils.stringToList(point, ",");
            float x = Float.parseFloat(points.get(0));
            float y = Float.parseFloat(points.get(1));
            return new Point2D.Float(x, y);
        }
        catch (Throwable e) {
            Log.get().error("Unable to parse Point2D: " + point, e);
            return new Point2D.Float();
        }
    }

    public static String pointToString(Point2D point) {
        return point.getX() + "," + point.getY();
    }
}

