/*
 * Decompiled with CFR 0.152.
 */
package com.alee.utils.xml;

import com.alee.managers.log.Log;
import com.thoughtworks.xstream.converters.basic.AbstractSingleValueConverter;
import java.awt.Insets;
import java.util.StringTokenizer;

public class InsetsConverter
extends AbstractSingleValueConverter {
    public static final String separator = ",";

    public boolean canConvert(Class type) {
        return Insets.class.isAssignableFrom(type);
    }

    public Object fromString(String insets) {
        return InsetsConverter.insetsFromString(insets);
    }

    public String toString(Object object) {
        return InsetsConverter.insetsToString((Insets)object);
    }

    public static Insets insetsFromString(String insets) {
        try {
            StringTokenizer tokenizer = new StringTokenizer(insets, separator, false);
            if (tokenizer.hasMoreTokens()) {
                int top = Integer.parseInt(tokenizer.nextToken().trim());
                if (tokenizer.hasMoreTokens()) {
                    int left = Integer.parseInt(tokenizer.nextToken().trim());
                    if (tokenizer.hasMoreTokens()) {
                        int bottom = Integer.parseInt(tokenizer.nextToken().trim());
                        int right = Integer.parseInt(tokenizer.nextToken().trim());
                        return new Insets(top, left, bottom, right);
                    }
                    return new Insets(top, left, top, left);
                }
                return new Insets(top, top, top, top);
            }
            return new Insets(0, 0, 0, 0);
        }
        catch (Throwable e) {
            Log.get().error("Unable to parse Insets: " + insets, e);
            return new Insets(0, 0, 0, 0);
        }
    }

    public static String insetsToString(Insets insets) {
        if (insets.top == insets.left && insets.left == insets.bottom && insets.bottom == insets.right) {
            return Integer.toString(insets.top);
        }
        return insets.top + separator + insets.left + separator + insets.bottom + separator + insets.right;
    }
}

