/*
 * Decompiled with CFR 0.152.
 */
package com.alee.utils.swing;

import com.alee.managers.log.Log;
import java.util.HashMap;
import java.util.Map;
import javax.swing.ImageIcon;

public class EnumLazyIconProvider {
    private static final Map<Enum, Map<String, ImageIcon>> icons = new HashMap<Enum, Map<String, ImageIcon>>();
    private static final String DEFAULT_EXTENSION = ".png";

    public static <E extends Enum<E>> ImageIcon getIcon(E enumeration, String folder) {
        return EnumLazyIconProvider.getIcon(enumeration, null, folder);
    }

    public static <E extends Enum<E>> ImageIcon getIcon(E enumeration, String state, String folder) {
        return EnumLazyIconProvider.getIcon(enumeration, state, folder, DEFAULT_EXTENSION);
    }

    public static <E extends Enum<E>> ImageIcon getIcon(E enumeration, String state, String folder, String extension) {
        ImageIcon imageIcon;
        Map<String, ImageIcon> stateIcons = icons.get(enumeration);
        if (stateIcons == null) {
            stateIcons = new HashMap<String, ImageIcon>(1);
            icons.put(enumeration, stateIcons);
        }
        if ((imageIcon = stateIcons.get(state)) == null && !stateIcons.containsKey(state)) {
            String stateSuffix = state != null ? "-" + state : "";
            String path = folder + enumeration + stateSuffix + extension;
            try {
                imageIcon = new ImageIcon(enumeration.getClass().getResource(path));
                stateIcons.put(state, imageIcon);
            }
            catch (Throwable e) {
                String cn = enumeration.getClass().getCanonicalName();
                Log.error(EnumLazyIconProvider.class, "Unable to find icon \"" + path + "\" near class: " + cn);
                stateIcons.put(state, null);
            }
        }
        return imageIcon;
    }
}

