/*
 * Decompiled with CFR 0.152.
 */
package com.alee.utils;

import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;

public final class NetUtils {
    public static String getAddress(URL url) {
        try {
            return url.toURI().toASCIIString();
        }
        catch (URISyntaxException e) {
            return url.toExternalForm();
        }
    }

    public static URL getURL(String address) {
        try {
            return new URL(address);
        }
        catch (MalformedURLException e) {
            return null;
        }
    }

    public static URI getURI(String address) {
        URL url = NetUtils.getURL(address);
        return url != null ? NetUtils.toURI(url) : null;
    }

    public static URI toURI(URL url) {
        try {
            return url != null ? url.toURI() : null;
        }
        catch (URISyntaxException e) {
            return null;
        }
    }

    public static String getHost(String address) {
        URL url = NetUtils.getURL(address);
        return url != null ? url.getHost() : null;
    }

    public static int getPort(String address) {
        URL url = NetUtils.getURL(address);
        return url != null ? url.getPort() : -1;
    }

    public static String getBaseAddress(String address) {
        URL url = NetUtils.getURL(address);
        return url != null ? url.getHost() + (url.getPort() != 80 && url.getPort() != -1 ? ":" + url.getPort() : "") : null;
    }

    public static String joinUrlPaths(String part1, String part2) {
        String separator = "/";
        boolean p1s = part1.endsWith("/");
        boolean p2s = part2.startsWith("/");
        if (p1s && p2s) {
            return part1 + part2.substring(1);
        }
        if (!p1s && !p2s) {
            return part1 + "/" + part2;
        }
        return part1 + part2;
    }
}

