/*
 * Decompiled with CFR 0.152.
 */
package com.alee.utils;

import com.alee.api.Identifiable;
import com.alee.api.Mergeable;
import com.alee.managers.log.Log;
import com.alee.utils.CompareUtils;
import com.alee.utils.ReflectUtils;
import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Modifier;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public final class MergeUtils {
    public static <T> T merge(T existing, T merged) {
        T mergedClone = MergeUtils.clone(merged);
        return MergeUtils.mergeImpl(existing, mergedClone);
    }

    private static <T> T mergeImpl(T existing, T merged) {
        if (existing != null && merged != null && existing.getClass() == merged.getClass()) {
            if (merged instanceof Mergeable) {
                return (T)((Mergeable)existing).merge((Mergeable)merged);
            }
            if (merged.getClass().isArray()) {
                int ml;
                int el = Array.getLength(existing);
                T result = el >= (ml = Array.getLength(merged)) ? existing : Array.newInstance(merged.getClass().getComponentType(), ml);
                for (int i = 0; i < ml; ++i) {
                    Array.set(result, i, MergeUtils.merge(Array.get(existing, i), Array.get(merged, i)));
                }
                return result;
            }
            if (merged instanceof Map) {
                Map existingMap = (Map)existing;
                Map mergedMap = (Map)merged;
                for (Map.Entry entry : mergedMap.entrySet()) {
                    String k = (String)entry.getKey();
                    Object e = existingMap.get(k);
                    Object v = entry.getValue();
                    existingMap.put(k, MergeUtils.merge(e, v));
                }
                return (T)existingMap;
            }
            if (merged instanceof List) {
                List existingList = (List)existing;
                List mergedList = (List)merged;
                for (Object mergedObject : mergedList) {
                    if (mergedObject != null && mergedObject instanceof Identifiable) {
                        String mid = ((Identifiable)mergedObject).getId();
                        boolean found = false;
                        for (int j = 0; j < existingList.size(); ++j) {
                            String eid;
                            Object existingObject = existingList.get(j);
                            if (existingObject == null || !CompareUtils.equals(eid = ((Identifiable)existingObject).getId(), mid)) continue;
                            if (existingObject.getClass() == mergedObject.getClass()) {
                                existingList.set(j, MergeUtils.merge(existingObject, mergedObject));
                            } else {
                                existingList.set(j, mergedObject);
                            }
                            found = true;
                            break;
                        }
                        if (found) continue;
                        existingList.add(mergedObject);
                        continue;
                    }
                    existingList.add(mergedObject);
                }
                return (T)existingList;
            }
            return merged;
        }
        if (merged != null) {
            return merged;
        }
        return existing;
    }

    public static <T> T clone(T object) {
        if (object != null && !object.getClass().isPrimitive()) {
            if (object.getClass().isArray()) {
                try {
                    Class<?> type = object.getClass().getComponentType();
                    int length = Array.getLength(object);
                    Object newArray = Array.newInstance(type, length);
                    for (int i = 0; i < length; ++i) {
                        Array.set(newArray, i, MergeUtils.clone(Array.get(object, i)));
                    }
                }
                catch (Throwable e) {
                    Log.get().error("Unable to instantiate array: " + object.getClass(), e);
                }
            } else if (object instanceof Map) {
                try {
                    Map clone = (Map)ReflectUtils.createInstance(object.getClass(), new Object[0]);
                    Iterator iterator = ((Map)object).entrySet().iterator();
                    while (iterator.hasNext()) {
                        Map.Entry e;
                        Map.Entry entry = e = iterator.next();
                        clone.put(entry.getKey(), MergeUtils.clone(entry.getValue()));
                    }
                    return (T)clone;
                }
                catch (Throwable e) {
                    Log.get().error("Unable to instantiate map: " + object.getClass(), e);
                }
            } else if (object instanceof Collection) {
                try {
                    Collection clone = (Collection)ReflectUtils.createInstance(object.getClass(), new Object[0]);
                    for (Object element : (Collection)object) {
                        clone.add(MergeUtils.clone(element));
                    }
                    return (T)clone;
                }
                catch (Throwable e) {
                    Log.get().error("Unable to instantiate collection: " + object.getClass(), e);
                }
            } else if (object instanceof Cloneable) {
                try {
                    Cloneable clone = ReflectUtils.clone((Cloneable)object);
                    return (T)(clone != null ? clone : object);
                }
                catch (Throwable e) {
                    Log.get().error("Unable to clone object: " + object, e);
                }
            }
        }
        return object;
    }

    public static <T> T cloneByFields(T object, Object ... arguments) throws InvocationTargetException, NoSuchMethodException, InstantiationException, IllegalAccessException {
        Object copy = ReflectUtils.createInstance(object.getClass(), arguments);
        List<Field> fields = ReflectUtils.getFields(object);
        for (Field field : fields) {
            field.setAccessible(true);
            if (Modifier.isTransient(field.getModifiers())) continue;
            Object value = field.get(object);
            Object clone = MergeUtils.clone(value);
            field.set(copy, clone);
        }
        return copy;
    }

    public static <T> T cloneByFieldsSafely(T object, Object ... arguments) {
        try {
            return MergeUtils.cloneByFields(object, arguments);
        }
        catch (Throwable e) {
            Log.warn("Unable to clone object by its fields: " + object, e);
            return null;
        }
    }
}

