/*
 * Decompiled with CFR 0.152.
 */
package de.sciss.treetable.j.event;

import de.sciss.treetable.j.TreeTable;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import javax.swing.tree.TreePath;

public class TreeTableMouseEvent
extends MouseEvent {
    private TreePath path = null;
    private int row = Integer.MIN_VALUE;
    private int column = Integer.MIN_VALUE;
    private int treePosition = Integer.MIN_VALUE;

    public TreeTableMouseEvent(TreeTable source, MouseEvent e) {
        super(source, e.getID(), e.getWhen(), e.getModifiers(), e.getX(), e.getY(), e.getXOnScreen(), e.getYOnScreen(), e.getClickCount(), e.isPopupTrigger(), e.getButton());
    }

    @Override
    public Point getPoint() {
        return new Point(this.getX(), this.getY());
    }

    public TreeTable getTreeTable() {
        return (TreeTable)this.getSource();
    }

    public int getRow() {
        if (this.row == Integer.MIN_VALUE) {
            this.row = this.getTreeTable().rowAtPoint(this.getPoint());
        }
        return this.row;
    }

    public int getColumn() {
        if (this.column == Integer.MIN_VALUE) {
            this.column = this.getTreeTable().columnAtPoint(this.getPoint());
        }
        return this.column;
    }

    public TreePath getTreePath() {
        if (this.path == null) {
            this.path = this.getTreeTable().getClosestPathForLocation(this.getX(), this.getY());
        }
        return this.path;
    }

    public int getDistanceToTreeHandle() {
        if (this.treePosition == Integer.MIN_VALUE) {
            this.treePosition = this.getTreeTable().getDistanceToTreeHandle(this.getTreePath(), this.getX());
        }
        return this.treePosition;
    }

    public boolean isOverTreeMargin() {
        return this.getColumn() == this.getTreeTable().getHierarchicalColumn() && this.getDistanceToTreeHandle() < 0;
    }

    public boolean isOverTreeHandle() {
        return this.getDistanceToTreeHandle() == 0;
    }

    public boolean isOverTreeNode() {
        int pos = this.getDistanceToTreeHandle();
        if (pos <= 0) {
            return false;
        }
        Rectangle nb = this.getTreeTable().getPathBounds(this.getTreePath());
        return pos < nb.width;
    }
}

