/*
 * Decompiled with CFR 0.152.
 */
package de.sciss.treetable.j;

import de.sciss.treetable.j.AbstractTreeColumnModel;
import de.sciss.treetable.j.MutableTreeTableNode;
import de.sciss.treetable.j.TreeTableNode;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import javax.swing.tree.TreeNode;

public class DefaultTreeColumnModel
extends AbstractTreeColumnModel {
    private List<?> columnNames;
    private int editableColumns = -1;
    private int hierarchialColumn;
    private TreeTableNode root;

    public DefaultTreeColumnModel(int columns) {
        this(null, columns);
    }

    public DefaultTreeColumnModel(TreeTableNode root) {
        this(root, Collections.nCopies(root.getColumnCount(), null));
    }

    public DefaultTreeColumnModel(TreeTableNode root, Object ... columnNames) {
        this(root, Arrays.asList(columnNames));
    }

    public DefaultTreeColumnModel(TreeTableNode root, List<?> columnNames) {
        this.root = root;
        this.columnNames = columnNames;
    }

    @Override
    public String getColumnName(int column) {
        Object name = this.columnNames.get(column);
        String str = name == null ? null : name.toString();
        return str != null ? str : super.getColumnName(column);
    }

    @Override
    public Class<?> getColumnClass(int column) {
        if (this.root == null) {
            return Object.class;
        }
        Object value = this.root.getValueAt(column);
        if (value instanceof Class) {
            return (Class)value;
        }
        return value == null ? Object.class : value.getClass();
    }

    @Override
    public int getColumnCount() {
        return this.columnNames.size();
    }

    @Override
    public Object getValueAt(Object node, int column) {
        return ((TreeTableNode)node).getValueAt(column);
    }

    @Override
    public void setValueAt(Object value, Object node, int column) {
        ((MutableTreeTableNode)node).setValueAt(this.convertValue(value, node, column), column);
        this.fireTreeColumnChanged(DefaultTreeColumnModel.pathToRoot(this.root, (TreeNode)node), column);
    }

    @Override
    public boolean isCellEditable(Object node, int column) {
        return (this.editableColumns & 1 << column) != 0;
    }

    public void setAllColumnsEditable(boolean editable) {
        this.editableColumns = editable ? -1 : 0;
    }

    public void setColumnEditable(int column, boolean editable) {
        if (column > 31) {
            throw new IllegalArgumentException();
        }
        this.editableColumns = editable ? (this.editableColumns |= 1 << column) : (this.editableColumns &= ~(1 << column));
    }

    @Override
    public int getHierarchicalColumn() {
        return this.hierarchialColumn;
    }

    public void setHierarchialColumn(int column) {
        this.hierarchialColumn = column;
    }
}

