/*
 * Decompiled with CFR 0.152.
 */
package de.sciss.syntaxpane;

import java.awt.Color;
import java.awt.FontMetrics;
import java.awt.Graphics;
import javax.swing.text.Segment;
import javax.swing.text.TabExpander;
import javax.swing.text.Utilities;

public final class SyntaxStyle {
    private Color color;
    private int fontStyle;

    public SyntaxStyle() {
    }

    public SyntaxStyle(Color color, boolean bold, boolean italic) {
        this.color = color;
        this.setBold(bold);
        this.setItalic(italic);
    }

    public SyntaxStyle(Color color, int fontStyle) {
        this.color = color;
        this.fontStyle = fontStyle;
    }

    public SyntaxStyle(String str) {
        String[] parts = str.split("\\s*,\\s*");
        if (parts.length != 2) {
            throw new IllegalArgumentException("style not correct format: " + str);
        }
        this.color = new Color(Integer.decode(parts[0]));
        this.fontStyle = Integer.decode(parts[1]);
    }

    public boolean isBold() {
        return (this.fontStyle & 1) != 0;
    }

    public void setBold(Boolean bold) {
        if (bold.booleanValue()) {
            this.fontStyle |= 1;
        } else {
            int mask = -2;
            this.fontStyle &= mask;
        }
    }

    public String getColorString() {
        return String.format("0x%06x", this.color.getRGB() & 0xFFFFFF);
    }

    public void setColorString(String color) {
        this.color = Color.decode(color);
    }

    public Boolean isItalic() {
        return (this.fontStyle & 2) != 0;
    }

    public void setItalic(Boolean italic) {
        this.fontStyle = italic.booleanValue() ? (this.fontStyle |= 2) : (this.fontStyle &= 0xFFFFFFFD);
    }

    public int getFontStyle() {
        return this.fontStyle;
    }

    public Color getColor() {
        return this.color;
    }

    public int drawText(Segment segment, int x, int y, Graphics graphics, TabExpander e, int startOffset) {
        graphics.setFont(graphics.getFont().deriveFont(this.getFontStyle()));
        FontMetrics fontMetrics = graphics.getFontMetrics();
        int a = fontMetrics.getAscent();
        int h = a + fontMetrics.getDescent();
        int w = Utilities.getTabbedTextWidth(segment, fontMetrics, 0, e, startOffset);
        int rX = x - 1;
        int rY = y - a;
        int rW = w + 2;
        int rH = h;
        if ((this.getFontStyle() & 0x10) != 0) {
            graphics.setColor(Color.decode("#EEEEEE"));
            graphics.fillRect(rX, rY, rW, rH);
        }
        graphics.setColor(this.getColor());
        x = Utilities.drawTabbedText(segment, x, y, graphics, e, startOffset);
        if ((this.getFontStyle() & 8) != 0) {
            graphics.setColor(Color.RED);
            graphics.drawRect(rX, rY, rW, rH);
        }
        return x;
    }
}

