/*
 * Decompiled with CFR 0.152.
 */
package de.sciss.submin;

import com.alee.laf.menu.MenuPainter;
import com.alee.laf.menu.WebMenuUI;
import com.alee.utils.GraphicsUtils;
import com.alee.utils.LafUtils;
import java.awt.Color;
import java.awt.Composite;
import java.awt.GradientPaint;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.Shape;
import javax.swing.JComponent;
import javax.swing.JMenu;
import javax.swing.JPopupMenu;

public class SubminMenuPainter<E extends JMenu, U extends WebMenuUI>
extends MenuPainter<E, U> {
    protected Color shadeColor;
    protected Float hoverOpacity;
    protected Color borderColor;

    public Color getShadeColor() {
        return this.shadeColor;
    }

    public void setShadeColor(Color shadeColor) {
        this.shadeColor = shadeColor;
    }

    public Color getBorderColor() {
        return this.borderColor;
    }

    public void setBorderColor(Color borderColor) {
        this.borderColor = borderColor;
    }

    public float getHoverOpacity() {
        return this.hoverOpacity != null ? this.hoverOpacity.floatValue() : 1.0f;
    }

    public void setHoverOpacity(float opacity) {
        this.hoverOpacity = Float.valueOf(opacity);
    }

    protected void paintBackground(Graphics2D g2d, boolean selected) {
        if (((JMenu)this.component).getParent() instanceof JPopupMenu) {
            if (selected) {
                g2d.setPaint(new GradientPaint(0.0f, 0.0f, this.selectedTopBg, 0.0f, ((JMenu)this.component).getHeight(), this.selectedBottomBg));
                g2d.fillRect(0, 0, ((JMenu)this.component).getWidth(), ((JMenu)this.component).getHeight());
            }
        } else if (((JMenu)this.component).isEnabled() && (selected || this.mouseover)) {
            float opacity = selected ? 1.0f : this.getHoverOpacity();
            GradientPaint bgPaint = new GradientPaint(0.0f, 0.0f, this.selectedTopBg, 0.0f, ((JMenu)this.component).getHeight(), this.selectedBottomBg);
            this.drawShape(g2d, this.component, this.shadeColor, this.shadeWidth, this.round, ((JMenu)this.component).isEnabled(), this.borderColor, this.borderColor, bgPaint, opacity);
        }
    }

    private Shape drawShape(Graphics2D g2d, JComponent component, Color shadeColor, int shadeWidth, int round, boolean fillBackground, Color border, Color disabledBorder, Paint background, float opacity) {
        if (opacity <= 0.0f || opacity > 1.0f) {
            return null;
        }
        Object aa = GraphicsUtils.setupAntialias((Graphics2D)g2d);
        Composite oc = GraphicsUtils.setupAlphaComposite((Graphics2D)g2d, (Float)Float.valueOf(opacity), (opacity < 1.0f ? 1 : 0) != 0);
        Shape borderShape = LafUtils.getWebBorderShape((JComponent)component, (int)shadeWidth, (int)round);
        if (component.isEnabled() && shadeColor != null) {
            GraphicsUtils.drawShade((Graphics2D)g2d, (Shape)borderShape, (Color)shadeColor, (int)shadeWidth);
        }
        if (fillBackground) {
            g2d.setPaint(background);
            if (round > 0) {
                g2d.fillRoundRect(shadeWidth, shadeWidth, component.getWidth() - shadeWidth * 2, component.getHeight() - shadeWidth * 2, round * 2 + 2, round * 2 + 2);
            } else {
                g2d.fillRect(shadeWidth, shadeWidth, component.getWidth() - shadeWidth * 2, component.getHeight() - shadeWidth * 2);
            }
        }
        if (border != null) {
            g2d.setPaint(component.isEnabled() ? border : disabledBorder);
            g2d.draw(borderShape);
        }
        GraphicsUtils.restoreComposite((Graphics2D)g2d, (Composite)oc, (opacity < 1.0f ? 1 : 0) != 0);
        GraphicsUtils.restoreAntialias((Graphics2D)g2d, (Object)aa);
        return borderShape;
    }
}

