/*
 * Decompiled with CFR 0.152.
 */
package de.sciss.synth.proc;

import de.sciss.synth.AudioBus;
import de.sciss.synth.ControlBus;
import de.sciss.synth.Server;
import de.sciss.synth.proc.RichAudioBus;
import de.sciss.synth.proc.RichBus;
import de.sciss.synth.proc.RichControlBus;
import de.sciss.synth.proc.Server;
import de.sciss.synth.proc.Txn;
import scala.Function0;
import scala.Function1;
import scala.Option;
import scala.Predef$;
import scala.ScalaObject;
import scala.Serializable;
import scala.Tuple2;
import scala.collection.MapLike;
import scala.collection.Seq;
import scala.collection.TraversableLike;
import scala.collection.immutable.Map;
import scala.collection.immutable.SortedMap;
import scala.concurrent.stm.Ref;
import scala.concurrent.stm.Ref$;
import scala.reflect.ClassManifest$;
import scala.reflect.Manifest$;
import scala.reflect.OptManifest;
import scala.runtime.BoxesRunTime;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class RichBus$
implements ScalaObject {
    public static final RichBus$ MODULE$;
    private boolean verbose;
    private final Ref<Map<Server, SortedMap<Object, RichBus.BusHolder<AudioBus>>>> readOnlyBuses;
    private final Ref<Map<Server, SortedMap<Object, RichBus.BusHolder<AudioBus>>>> writeOnlyBuses;

    static {
        new RichBus$();
    }

    public RichAudioBus audio(Server server, int numChannels) {
        return new RichBus.AudioImpl(server, numChannels);
    }

    public RichControlBus control(Server server, int numChannels) {
        return new RichBus.ControlImpl(server, numChannels);
    }

    public RichAudioBus tmpAudio(Server server, int numChannels) {
        return new RichBus.TempAudioImpl(server, numChannels);
    }

    public RichAudioBus soundIn(Server server, int numChannels, int offset) {
        Server.Config o = server.peer().config();
        Predef$.MODULE$.require(offset + numChannels <= o.inputBusChannels(), (Function0)new Serializable(){
            public static final long serialVersionUID;

            static {
                long l = serialVersionUID = 0L;
            }

            public final String apply() {
                return "soundIn - offset is beyond allocated hardware channels";
            }
        });
        return new RichBus.FixedImpl(server, new AudioBus(server.peer(), o.outputBusChannels() + offset, numChannels));
    }

    public int soundIn$default$3() {
        return 0;
    }

    public RichAudioBus soundOut(Server server, int numChannels, int offset) {
        Server.Config o = server.peer().config();
        Predef$.MODULE$.require(offset + numChannels <= o.outputBusChannels(), (Function0)new Serializable(){
            public static final long serialVersionUID;

            static {
                long l = serialVersionUID = 0L;
            }

            public final String apply() {
                return "soundOut - offset is beyond allocated hardware channels";
            }
        });
        return new RichBus.FixedImpl(server, new AudioBus(server.peer(), offset, numChannels));
    }

    public int soundOut$default$3() {
        return 0;
    }

    public RichAudioBus wrap(Server server, AudioBus bus) {
        de.sciss.synth.Server server2 = server.peer();
        de.sciss.synth.Server server3 = bus.server();
        Predef$.MODULE$.require(!(server2 != null ? !server2.equals(server3) : server3 != null));
        return new RichBus.FixedImpl(server, bus);
    }

    public boolean verbose() {
        return this.verbose;
    }

    public void verbose_$eq(boolean bl) {
        this.verbose = bl;
    }

    private Ref<Map<Server, SortedMap<Object, RichBus.BusHolder<AudioBus>>>> readOnlyBuses() {
        return this.readOnlyBuses;
    }

    private Ref<Map<Server, SortedMap<Object, RichBus.BusHolder<AudioBus>>>> writeOnlyBuses() {
        return this.writeOnlyBuses;
    }

    public final RichBus.BusHolder<AudioBus> de$sciss$synth$proc$RichBus$$createReadOnlyBus(Server server, int numChannels, Txn tx) {
        return this.createRichAudioBus(server, numChannels, this.readOnlyBuses(), tx);
    }

    public final RichBus.BusHolder<AudioBus> de$sciss$synth$proc$RichBus$$createWriteOnlyBus(Server server, int numChannels, Txn tx) {
        return this.createRichAudioBus(server, numChannels, this.writeOnlyBuses(), tx);
    }

    private RichBus.BusHolder<AudioBus> createRichAudioBus(Server server$2, int numChannels$1, Ref<Map<Server, SortedMap<Object, RichBus.BusHolder<AudioBus>>>> mapScalaRef$1, Txn tx$1) {
        Option chanMapO = ((MapLike)mapScalaRef$1.get((Object)tx$1.peer())).get((Object)server$2);
        RichBus.BusHolder bus = (RichBus.BusHolder)chanMapO.flatMap((Function1)new Serializable(numChannels$1){
            public static final long serialVersionUID;
            private final int numChannels$1;

            static {
                long l = serialVersionUID = 0L;
            }

            public final Option<RichBus.BusHolder<AudioBus>> apply(SortedMap<Object, RichBus.BusHolder<AudioBus>> sortedMap) {
                return ((TraversableLike)sortedMap.from((Object)BoxesRunTime.boxToInteger((int)this.numChannels$1))).headOption().map((Function1)new Serializable(this){
                    public static final long serialVersionUID;

                    static {
                        long l = serialVersionUID = 0L;
                    }

                    public final RichBus.BusHolder<AudioBus> apply(Tuple2<Object, RichBus.BusHolder<AudioBus>> tuple2) {
                        return (RichBus.BusHolder)tuple2._2();
                    }
                });
            }
            {
                this.numChannels$1 = n;
            }
        }).getOrElse((Function0)new Serializable(server$2, numChannels$1, mapScalaRef$1, tx$1){
            public static final long serialVersionUID;
            private final Server server$2;
            private final int numChannels$1;
            private final Ref mapScalaRef$1;
            private final Txn tx$1;

            static {
                long l = serialVersionUID = 0L;
            }

            /*
             * WARNING - void declaration
             */
            public final RichBus.RichAudioBusHolder apply() {
                void var3_3;
                int index = this.server$2.allocAudioBus(this.numChannels$1, this.tx$1);
                AudioBus peer = new AudioBus(this.server$2.peer(), index, this.numChannels$1);
                RichBus.RichAudioBusHolder res = new RichBus.RichAudioBusHolder(this.server$2, peer, (Ref<Map<Server, SortedMap<Object, RichBus.BusHolder<AudioBus>>>>)this.mapScalaRef$1);
                res.add(this.tx$1);
                return var3_3;
            }
            {
                this.server$2 = server;
                this.numChannels$1 = n;
                this.mapScalaRef$1 = ref;
                this.tx$1 = txn;
            }
        });
        return bus;
    }

    public final RichBus.BusHolder<AudioBus> de$sciss$synth$proc$RichBus$$createAudioBus(Server server, int numChannels, Txn tx) {
        int index = server.allocAudioBus(numChannels, tx);
        AudioBus peer = new AudioBus(server.peer(), index, numChannels);
        return new RichBus.PlainAudioBusHolder(server, peer);
    }

    public final RichBus.BusHolder<ControlBus> de$sciss$synth$proc$RichBus$$createControlBus(Server server, int numChannels, Txn tx) {
        int index = server.allocControlBus(numChannels, tx);
        ControlBus peer = new ControlBus(server.peer(), index, numChannels);
        return new RichBus.PlainControlBusHolder(server, peer);
    }

    private RichBus$() {
        MODULE$ = this;
        this.verbose = false;
        this.readOnlyBuses = Ref$.MODULE$.apply((Object)Predef$.MODULE$.Map().empty(), (OptManifest)ClassManifest$.MODULE$.classType(Map.class, (OptManifest)ClassManifest$.MODULE$.classType(Server.class), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new OptManifest[]{ClassManifest$.MODULE$.classType(SortedMap.class, (OptManifest)Manifest$.MODULE$.Int(), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new OptManifest[]{ClassManifest$.MODULE$.classType(RichBus.BusHolder.class, (OptManifest)ClassManifest$.MODULE$.classType(AudioBus.class), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new OptManifest[0]))}))})));
        this.writeOnlyBuses = Ref$.MODULE$.apply((Object)Predef$.MODULE$.Map().empty(), (OptManifest)ClassManifest$.MODULE$.classType(Map.class, (OptManifest)ClassManifest$.MODULE$.classType(Server.class), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new OptManifest[]{ClassManifest$.MODULE$.classType(SortedMap.class, (OptManifest)Manifest$.MODULE$.Int(), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new OptManifest[]{ClassManifest$.MODULE$.classType(RichBus.BusHolder.class, (OptManifest)ClassManifest$.MODULE$.classType(AudioBus.class), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new OptManifest[0]))}))})));
    }
}

