/*
 * Decompiled with CFR 0.152.
 */
package de.sciss.freesound;

import com.jcraft.jogg.Packet;
import com.jcraft.jogg.Page;
import com.jcraft.jogg.StreamState;
import com.jcraft.jogg.SyncState;
import com.jcraft.jorbis.Block;
import com.jcraft.jorbis.Comment;
import com.jcraft.jorbis.DspState;
import com.jcraft.jorbis.Info;
import de.sciss.synth.io.AudioFile;
import de.sciss.synth.io.AudioFile$;
import de.sciss.synth.io.AudioFileSpec;
import de.sciss.synth.io.AudioFileSpec$;
import de.sciss.synth.io.AudioFileType;
import de.sciss.synth.io.SampleFormat;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import scala.Option;
import scala.Predef$;
import scala.StringContext;
import scala.collection.Seq;
import scala.collection.immutable.Nil$;
import scala.math.package$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

public final class OggDecoder$ {
    public static OggDecoder$ MODULE$;

    static {
        new OggDecoder$();
    }

    public AudioFileSpec decode(InputStream is, File fOut, AudioFileType tpeOut, SampleFormat fmtOut) {
        AudioFileSpec audioFileSpec;
        SyncState sync = new SyncState();
        StreamState stream = new StreamState();
        Page page = new Page();
        Packet packet = new Packet();
        Info info = new Info();
        Comment comment = new Comment();
        DspState dsp = new DspState();
        Block block = new Block(dsp);
        sync.init();
        float[][][] _pcm = new float[1][][];
        try (AudioFile afOut = null;){
            while (true) {
                boolean hasPage;
                int off = sync.buffer(4096);
                byte[] buf = sync.data;
                int len = is.read(buf, off, 4096);
                sync.wrote(len);
                boolean bl = hasPage = sync.pageout(page) == 1;
                if (!hasPage && len == 4096) {
                    throw new IOException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Input does not appear to be an Ogg bit stream"})).s((Seq)Nil$.MODULE$));
                }
                if (!hasPage) break;
                boolean eos = false;
                stream.init(page.serialno());
                info.init();
                comment.init();
                if (stream.pagein(page) < 0) {
                    throw new IOException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Error reading first page of Ogg bit stream data"})).s((Seq)Nil$.MODULE$));
                }
                if (stream.packetout(packet) != 1) {
                    throw new IOException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Error reading initial header packet"})).s((Seq)Nil$.MODULE$));
                }
                if (info.synthesis_headerin(comment, packet) < 0) {
                    throw new IOException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"The Ogg bit stream does not contain Vorbis audio data"})).s((Seq)Nil$.MODULE$));
                }
                int i = 0;
                while (i < 2) {
                    int result = 0;
                    do {
                        if ((result = sync.pageout(page)) != 1) continue;
                        stream.pagein(page);
                        do {
                            if ((result = stream.packetout(packet)) == -1) {
                                throw new IOException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Corrupt secondary header"})).s((Seq)Nil$.MODULE$));
                            }
                            if (result != 1) continue;
                            info.synthesis_headerin(comment, packet);
                            ++i;
                        } while (i < 2 && result != 0);
                    } while (i < 2 && result != 0);
                    byte[] buf2 = sync.data;
                    int off2 = sync.buffer(4096);
                    int len2 = is.read(buf2, off2, 4096);
                    if (len2 == 0 && i < 2) {
                        throw new IOException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"End of file before finding all Vorbis headers!"})).s((Seq)Nil$.MODULE$));
                    }
                    sync.wrote(len2);
                }
                if (afOut == null) {
                    afOut = AudioFile$.MODULE$.openWrite(fOut, new AudioFileSpec(tpeOut, fmtOut, info.channels, (double)info.rate, AudioFileSpec$.MODULE$.apply$default$5(), AudioFileSpec$.MODULE$.apply$default$6()));
                } else if (afOut.numChannels() != info.channels) {
                    throw new IOException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Cannot chain bit streams of varying number of channels (", " -> ", ")"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)afOut.numChannels()), BoxesRunTime.boxToInteger((int)info.channels)})));
                }
                int convSize = 4096;
                dsp.synthesis_init(info);
                block.init(dsp);
                int[] _index = new int[info.channels];
                while (!eos) {
                    int result0 = 0;
                    do {
                        if ((result0 = sync.pageout(page)) == -1) {
                            System.err.println("Corrupt or missing data in bit stream; continuing...");
                        }
                        if (result0 != 1) continue;
                        stream.pagein(page);
                        int result1 = 0;
                        do {
                            if ((result1 = stream.packetout(packet)) == -1) {
                                // empty if block
                            }
                            if (result1 != 1) continue;
                            Object object = block.synthesis(packet) == 0 ? BoxesRunTime.boxToInteger((int)dsp.synthesis_blockin(block)) : BoxedUnit.UNIT;
                            int avail = 0;
                            do {
                                Object object2;
                                if ((avail = dsp.synthesis_pcmout((float[][][])_pcm, _index)) > 0) {
                                    int chunk = package$.MODULE$.min(avail, convSize);
                                    int off3 = _index[0];
                                    float[][] buf3 = _pcm[0];
                                    afOut.write(buf3, off3, chunk);
                                    object2 = BoxesRunTime.boxToInteger((int)dsp.synthesis_read(chunk));
                                    continue;
                                }
                                object2 = BoxedUnit.UNIT;
                            } while (avail > 0);
                        } while (result1 != 0);
                        if (page.eos() == 0) continue;
                        eos = true;
                    } while (!eos && result0 != 0);
                    if (eos) continue;
                    int off4 = sync.buffer(4096);
                    byte[] buf4 = sync.data;
                    int len3 = is.read(buf4, off4, 4096);
                    sync.wrote(len3);
                    if (len3 != 0) continue;
                    eos = true;
                }
                stream.clear();
                block.clear();
                dsp.clear();
                info.clear();
            }
            sync.clear();
            AudioFileSpec qual$1 = afOut.spec();
            long x$1 = afOut.numFrames();
            AudioFileType x$2 = qual$1.copy$default$1();
            SampleFormat x$3 = qual$1.copy$default$2();
            int x$4 = qual$1.copy$default$3();
            double x$5 = qual$1.copy$default$4();
            Option x$6 = qual$1.copy$default$5();
            audioFileSpec = qual$1.copy(x$2, x$3, x$4, x$5, x$6, x$1);
        }
        return audioFileSpec;
    }

    public AudioFileType decode$default$3() {
        return AudioFileType.Wave$.MODULE$;
    }

    public SampleFormat decode$default$4() {
        return SampleFormat.Int16$.MODULE$;
    }

    private OggDecoder$() {
        MODULE$ = this;
    }
}

