/*
 * Decompiled with CFR 0.152.
 */
package prefuse.visual.expression;

import java.util.logging.Logger;
import prefuse.data.Tuple;
import prefuse.data.expression.AbstractExpression;
import prefuse.data.expression.Expression;
import prefuse.data.expression.Function;
import prefuse.data.expression.ObjectLiteral;

public abstract class GroupExpression
extends AbstractExpression
implements Function {
    private static final Logger s_logger = Logger.getLogger(GroupExpression.class.getName());
    protected Expression m_group;

    protected GroupExpression() {
        this.m_group = null;
    }

    protected GroupExpression(String group) {
        this.m_group = new ObjectLiteral(group);
    }

    protected String getGroup(Tuple t) {
        String group = (String)this.m_group.get(t);
        if (group == null) {
            s_logger.warning("Null group lookup");
        }
        return group;
    }

    @Override
    public void addParameter(Expression e) {
        if (this.m_group != null) {
            throw new IllegalStateException("This function takes only 1 parameter.");
        }
        this.m_group = e;
    }

    @Override
    public int getParameterCount() {
        return 1;
    }

    public String toString() {
        return this.getName() + "(" + this.m_group + ")";
    }
}

