/*
 * Decompiled with CFR 0.152.
 */
package prefuse.util.force;

import java.awt.geom.Line2D;
import prefuse.util.force.AbstractForce;
import prefuse.util.force.ForceItem;

public class WallForce
extends AbstractForce {
    private static String[] pNames = new String[]{"GravitationalConstant"};
    public static final float DEFAULT_GRAV_CONSTANT = -0.1f;
    public static final float DEFAULT_MIN_GRAV_CONSTANT = -1.0f;
    public static final float DEFAULT_MAX_GRAV_CONSTANT = 1.0f;
    public static final int GRAVITATIONAL_CONST = 0;
    private float x1;
    private float y1;
    private float x2;
    private float y2;
    private float dx;
    private float dy;

    public WallForce(float gravConst, float x1, float y1, float x2, float y2) {
        this.params = new float[]{gravConst};
        this.minValues = new float[]{-1.0f};
        this.maxValues = new float[]{1.0f};
        this.x1 = x1;
        this.y1 = y1;
        this.x2 = x2;
        this.y2 = y2;
        this.dx = x2 - x1;
        this.dy = y2 - y1;
        float r = (float)Math.sqrt(this.dx * this.dx + this.dy * this.dy);
        if ((double)this.dx != 0.0) {
            this.dx /= r;
        }
        if ((double)this.dy != 0.0) {
            this.dy /= r;
        }
    }

    public WallForce(float x1, float y1, float x2, float y2) {
        this(-0.1f, x1, y1, x2, y2);
    }

    @Override
    public boolean isItemForce() {
        return true;
    }

    @Override
    protected String[] getParameterNames() {
        return pNames;
    }

    @Override
    public void getForce(ForceItem item) {
        float[] n = item.location;
        int ccw = Line2D.relativeCCW(this.x1, this.y1, this.x2, this.y2, n[0], n[1]);
        float r = (float)Line2D.ptSegDist(this.x1, this.y1, this.x2, this.y2, n[0], n[1]);
        if ((double)r == 0.0) {
            r = (float)Math.random() / 100.0f;
        }
        float v = this.params[0] * item.mass / (r * r * r);
        if (n[0] >= Math.min(this.x1, this.x2) && n[0] <= Math.max(this.x1, this.x2)) {
            item.force[1] = item.force[1] + (float)ccw * v * this.dx;
        }
        if (n[1] >= Math.min(this.y1, this.y2) && n[1] <= Math.max(this.y1, this.y2)) {
            item.force[0] = item.force[0] + (float)(-1 * ccw) * v * this.dy;
        }
    }
}

