/*
 * Decompiled with CFR 0.152.
 */
package prefuse.util.force;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.Random;
import prefuse.util.force.AbstractForce;
import prefuse.util.force.ForceItem;
import prefuse.util.force.ForceSimulator;

public class NBodyForce
extends AbstractForce {
    private static String[] pNames = new String[]{"GravitationalConstant", "Distance", "BarnesHutTheta"};
    public static final float DEFAULT_GRAV_CONSTANT = -1.0f;
    public static final float DEFAULT_MIN_GRAV_CONSTANT = -10.0f;
    public static final float DEFAULT_MAX_GRAV_CONSTANT = 10.0f;
    public static final float DEFAULT_DISTANCE = -1.0f;
    public static final float DEFAULT_MIN_DISTANCE = -1.0f;
    public static final float DEFAULT_MAX_DISTANCE = 500.0f;
    public static final float DEFAULT_THETA = 0.9f;
    public static final float DEFAULT_MIN_THETA = 0.0f;
    public static final float DEFAULT_MAX_THETA = 1.0f;
    public static final int GRAVITATIONAL_CONST = 0;
    public static final int MIN_DISTANCE = 1;
    public static final int BARNES_HUT_THETA = 2;
    private float xMin;
    private float xMax;
    private float yMin;
    private float yMax;
    private QuadTreeNodeFactory factory = new QuadTreeNodeFactory();
    private QuadTreeNode root;
    private Random rand = new Random(12345678L);

    public NBodyForce() {
        this(-1.0f, -1.0f, 0.9f);
    }

    public NBodyForce(float gravConstant, float minDistance, float theta) {
        this.params = new float[]{gravConstant, minDistance, theta};
        this.minValues = new float[]{-10.0f, -1.0f, 0.0f};
        this.maxValues = new float[]{10.0f, 500.0f, 1.0f};
        this.root = this.factory.getQuadTreeNode();
    }

    @Override
    public boolean isItemForce() {
        return true;
    }

    @Override
    protected String[] getParameterNames() {
        return pNames;
    }

    private void setBounds(float xMin, float yMin, float xMax, float yMax) {
        this.xMin = xMin;
        this.yMin = yMin;
        this.xMax = xMax;
        this.yMax = yMax;
    }

    public void clear() {
        this.clearHelper(this.root);
        this.root = this.factory.getQuadTreeNode();
    }

    private void clearHelper(QuadTreeNode n) {
        for (int i = 0; i < n.children.length; ++i) {
            if (n.children[i] == null) continue;
            this.clearHelper(n.children[i]);
        }
        this.factory.reclaim(n);
    }

    @Override
    public void init(ForceSimulator fSim) {
        this.clear();
        float x1 = Float.MAX_VALUE;
        float y1 = Float.MAX_VALUE;
        float x2 = Float.MIN_VALUE;
        float y2 = Float.MIN_VALUE;
        Iterator itemIter = fSim.getItems();
        while (itemIter.hasNext()) {
            ForceItem item = (ForceItem)itemIter.next();
            float x = item.location[0];
            float y = item.location[1];
            if (x < x1) {
                x1 = x;
            }
            if (y < y1) {
                y1 = y;
            }
            if (x > x2) {
                x2 = x;
            }
            if (!(y > y2)) continue;
            y2 = y;
        }
        float dx = x2 - x1;
        float dy = y2 - y1;
        if (dx > dy) {
            y2 = y1 + dx;
        } else {
            x2 = x1 + dy;
        }
        this.setBounds(x1, y1, x2, y2);
        itemIter = fSim.getItems();
        while (itemIter.hasNext()) {
            ForceItem item = (ForceItem)itemIter.next();
            this.insert(item);
        }
        this.calcMass(this.root);
    }

    public void insert(ForceItem item) {
        try {
            this.insert(item, this.root, this.xMin, this.yMin, this.xMax, this.yMax);
        }
        catch (StackOverflowError e) {
            e.printStackTrace();
        }
    }

    private void insert(ForceItem p, QuadTreeNode n, float x1, float y1, float x2, float y2) {
        if (n.hasChildren) {
            this.insertHelper(p, n, x1, y1, x2, y2);
        } else if (n.value != null) {
            if (NBodyForce.isSameLocation(n.value, p)) {
                this.insertHelper(p, n, x1, y1, x2, y2);
            } else {
                ForceItem v = n.value;
                n.value = null;
                this.insertHelper(v, n, x1, y1, x2, y2);
                this.insertHelper(p, n, x1, y1, x2, y2);
            }
        } else {
            n.value = p;
        }
    }

    private static boolean isSameLocation(ForceItem f1, ForceItem f2) {
        float dx = Math.abs(f1.location[0] - f2.location[0]);
        float dy = Math.abs(f1.location[1] - f2.location[1]);
        return (double)dx < 0.01 && (double)dy < 0.01;
    }

    private void insertHelper(ForceItem p, QuadTreeNode n, float x1, float y1, float x2, float y2) {
        float splitY;
        float y;
        float x = p.location[0];
        float splitX = (x1 + x2) / 2.0f;
        int i = (x >= splitX ? 1 : 0) + ((y = p.location[1]) >= (splitY = (y1 + y2) / 2.0f) ? 2 : 0);
        if (n.children[i] == null) {
            n.children[i] = this.factory.getQuadTreeNode();
            n.hasChildren = true;
        }
        if (i == 1 || i == 3) {
            x1 = splitX;
        } else {
            x2 = splitX;
        }
        if (i > 1) {
            y1 = splitY;
        } else {
            y2 = splitY;
        }
        this.insert(p, n.children[i], x1, y1, x2, y2);
    }

    private void calcMass(QuadTreeNode n) {
        float xCom = 0.0f;
        float yCom = 0.0f;
        n.mass = 0.0f;
        if (n.hasChildren) {
            for (int i = 0; i < n.children.length; ++i) {
                if (n.children[i] == null) continue;
                this.calcMass(n.children[i]);
                n.mass += n.children[i].mass;
                xCom += n.children[i].mass * n.children[i].com[0];
                yCom += n.children[i].mass * n.children[i].com[1];
            }
        }
        if (n.value != null) {
            n.mass += n.value.mass;
            xCom += n.value.mass * n.value.location[0];
            yCom += n.value.mass * n.value.location[1];
        }
        n.com[0] = xCom / n.mass;
        n.com[1] = yCom / n.mass;
    }

    @Override
    public void getForce(ForceItem item) {
        try {
            this.forceHelper(item, this.root, this.xMin, this.yMin, this.xMax, this.yMax);
        }
        catch (StackOverflowError e) {
            e.printStackTrace();
        }
    }

    private void forceHelper(ForceItem item, QuadTreeNode n, float x1, float y1, float x2, float y2) {
        boolean minDist;
        float dx = n.com[0] - item.location[0];
        float dy = n.com[1] - item.location[1];
        float r = (float)Math.sqrt(dx * dx + dy * dy);
        boolean same = false;
        if (r == 0.0f) {
            dx = (this.rand.nextFloat() - 0.5f) / 50.0f;
            dy = (this.rand.nextFloat() - 0.5f) / 50.0f;
            r = (float)Math.sqrt(dx * dx + dy * dy);
            same = true;
        }
        boolean bl = minDist = this.params[1] > 0.0f && r > this.params[1];
        if (!n.hasChildren && n.value != item || !same && (x2 - x1) / r < this.params[2]) {
            if (minDist) {
                return;
            }
            float v = this.params[0] * item.mass * n.mass / (r * r * r);
            item.force[0] = item.force[0] + v * dx;
            item.force[1] = item.force[1] + v * dy;
        } else if (n.hasChildren) {
            float splitX = (x1 + x2) / 2.0f;
            float splitY = (y1 + y2) / 2.0f;
            for (int i = 0; i < n.children.length; ++i) {
                if (n.children[i] == null) continue;
                this.forceHelper(item, n.children[i], i == 1 || i == 3 ? splitX : x1, i > 1 ? splitY : y1, i == 1 || i == 3 ? x2 : splitX, i > 1 ? y2 : splitY);
            }
            if (minDist) {
                return;
            }
            if (n.value != null && n.value != item) {
                float v = this.params[0] * item.mass * n.value.mass / (r * r * r);
                item.force[0] = item.force[0] + v * dx;
                item.force[1] = item.force[1] + v * dy;
            }
        }
    }

    public static final class QuadTreeNodeFactory {
        private int maxNodes = 50000;
        private ArrayList nodes = new ArrayList();

        public QuadTreeNode getQuadTreeNode() {
            if (this.nodes.size() > 0) {
                return (QuadTreeNode)this.nodes.remove(this.nodes.size() - 1);
            }
            return new QuadTreeNode();
        }

        public void reclaim(QuadTreeNode n) {
            n.mass = 0.0f;
            n.com[0] = 0.0f;
            n.com[1] = 0.0f;
            n.value = null;
            n.hasChildren = false;
            Arrays.fill(n.children, null);
            if (this.nodes.size() < this.maxNodes) {
                this.nodes.add(n);
            }
        }
    }

    public static final class QuadTreeNode {
        boolean hasChildren = false;
        float mass;
        float[] com = new float[]{0.0f, 0.0f};
        ForceItem value;
        QuadTreeNode[] children = new QuadTreeNode[4];
    }
}

