/*
 * Decompiled with CFR 0.152.
 */
package prefuse.util.force;

import prefuse.util.force.AbstractForce;
import prefuse.util.force.ForceItem;

public class GravitationalForce
extends AbstractForce {
    private static final String[] pNames = new String[]{"GravitationalConstant", "Direction"};
    public static final int GRAVITATIONAL_CONST = 0;
    public static final int DIRECTION = 1;
    public static final float DEFAULT_FORCE_CONSTANT = 1.0E-4f;
    public static final float DEFAULT_MIN_FORCE_CONSTANT = 1.0E-5f;
    public static final float DEFAULT_MAX_FORCE_CONSTANT = 0.001f;
    public static final float DEFAULT_DIRECTION = -1.5707964f;
    public static final float DEFAULT_MIN_DIRECTION = (float)(-Math.PI);
    public static final float DEFAULT_MAX_DIRECTION = (float)Math.PI;

    public GravitationalForce(float forceConstant, float direction) {
        this.params = new float[]{forceConstant, direction};
        this.minValues = new float[]{1.0E-5f, (float)(-Math.PI)};
        this.maxValues = new float[]{0.001f, (float)Math.PI};
    }

    public GravitationalForce() {
        this(1.0E-4f, -1.5707964f);
    }

    @Override
    public boolean isItemForce() {
        return true;
    }

    @Override
    protected String[] getParameterNames() {
        return pNames;
    }

    @Override
    public void getForce(ForceItem item) {
        float theta = this.params[1];
        float coeff = this.params[0] * item.mass;
        item.force[0] = (float)((double)item.force[0] + Math.cos(theta) * (double)coeff);
        item.force[1] = (float)((double)item.force[1] + Math.sin(theta) * (double)coeff);
    }
}

