/*
 * Decompiled with CFR 0.152.
 */
package prefuse.util.force;

import java.util.ArrayList;
import java.util.Iterator;
import prefuse.util.force.Force;
import prefuse.util.force.ForceItem;
import prefuse.util.force.Integrator;
import prefuse.util.force.RungeKuttaIntegrator;
import prefuse.util.force.Spring;

public class ForceSimulator {
    private ArrayList items;
    private ArrayList springs;
    private Force[] iForces;
    private Force[] sForces;
    private int ifLen;
    private int sfLen;
    private Integrator integrator;
    private float speedLimit = 1.0f;

    public ForceSimulator() {
        this(new RungeKuttaIntegrator());
    }

    public ForceSimulator(Integrator integrator) {
        this.integrator = integrator;
        this.iForces = new Force[5];
        this.sForces = new Force[5];
        this.ifLen = 0;
        this.sfLen = 0;
        this.items = new ArrayList();
        this.springs = new ArrayList();
    }

    public float getSpeedLimit() {
        return this.speedLimit;
    }

    public void setSpeedLimit(float limit) {
        this.speedLimit = limit;
    }

    public Integrator getIntegrator() {
        return this.integrator;
    }

    public void setIntegrator(Integrator integrator) {
        this.integrator = integrator;
    }

    public void clear() {
        this.items.clear();
        Iterator sIter = this.springs.iterator();
        Spring.SpringFactory f = Spring.getFactory();
        while (sIter.hasNext()) {
            f.reclaim((Spring)sIter.next());
        }
        this.springs.clear();
    }

    public void addForce(Force f) {
        Force[] newF;
        if (f.isItemForce()) {
            if (this.iForces.length == this.ifLen) {
                newF = new Force[this.ifLen + 10];
                System.arraycopy(this.iForces, 0, newF, 0, this.iForces.length);
                this.iForces = newF;
            }
            this.iForces[this.ifLen++] = f;
        }
        if (f.isSpringForce()) {
            if (this.sForces.length == this.sfLen) {
                newF = new Force[this.sfLen + 10];
                System.arraycopy(this.sForces, 0, newF, 0, this.sForces.length);
                this.sForces = newF;
            }
            this.sForces[this.sfLen++] = f;
        }
    }

    public Force[] getForces() {
        Force[] rv = new Force[this.ifLen + this.sfLen];
        System.arraycopy(this.iForces, 0, rv, 0, this.ifLen);
        System.arraycopy(this.sForces, 0, rv, this.ifLen, this.sfLen);
        return rv;
    }

    public void addItem(ForceItem item) {
        this.items.add(item);
    }

    public boolean removeItem(ForceItem item) {
        return this.items.remove(item);
    }

    public Iterator getItems() {
        return this.items.iterator();
    }

    public Spring addSpring(ForceItem item1, ForceItem item2) {
        return this.addSpring(item1, item2, -1.0f, -1.0f);
    }

    public Spring addSpring(ForceItem item1, ForceItem item2, float length) {
        return this.addSpring(item1, item2, -1.0f, length);
    }

    public Spring addSpring(ForceItem item1, ForceItem item2, float coeff, float length) {
        if (item1 == null || item2 == null) {
            throw new IllegalArgumentException("ForceItems must be non-null");
        }
        Spring s = Spring.getFactory().getSpring(item1, item2, coeff, length);
        this.springs.add(s);
        return s;
    }

    public Iterator getSprings() {
        return this.springs.iterator();
    }

    public void runSimulator(long timeStep) {
        this.accumulate();
        this.integrator.integrate(this, timeStep);
    }

    public void accumulate() {
        int i;
        for (i = 0; i < this.ifLen; ++i) {
            this.iForces[i].init(this);
        }
        for (i = 0; i < this.sfLen; ++i) {
            this.sForces[i].init(this);
        }
        for (ForceItem item : this.items) {
            item.force[0] = 0.0f;
            item.force[1] = 0.0f;
            for (int i2 = 0; i2 < this.ifLen; ++i2) {
                this.iForces[i2].getForce(item);
            }
        }
        for (Spring s : this.springs) {
            for (int i3 = 0; i3 < this.sfLen; ++i3) {
                this.sForces[i3].getForce(s);
            }
        }
    }
}

