/*
 * Decompiled with CFR 0.152.
 */
package prefuse.util.force;

import java.util.Iterator;
import prefuse.util.force.ForceItem;
import prefuse.util.force.ForceSimulator;
import prefuse.util.force.Integrator;

public class EulerIntegrator
implements Integrator {
    @Override
    public void integrate(ForceSimulator sim, long timeStep) {
        float speedLimit = sim.getSpeedLimit();
        Iterator iter = sim.getItems();
        while (iter.hasNext()) {
            ForceItem item = (ForceItem)iter.next();
            item.location[0] = item.location[0] + (float)timeStep * item.velocity[0];
            item.location[1] = item.location[1] + (float)timeStep * item.velocity[1];
            float coeff = (float)timeStep / item.mass;
            item.velocity[0] = item.velocity[0] + coeff * item.force[0];
            item.velocity[1] = item.velocity[1] + coeff * item.force[1];
            float vx = item.velocity[0];
            float vy = item.velocity[1];
            float v = (float)Math.sqrt(vx * vx + vy * vy);
            if (!(v > speedLimit)) continue;
            item.velocity[0] = speedLimit * vx / v;
            item.velocity[1] = speedLimit * vy / v;
        }
    }
}

