/*
 * Decompiled with CFR 0.152.
 */
package prefuse.util.force;

import prefuse.util.force.Force;
import prefuse.util.force.ForceItem;
import prefuse.util.force.ForceSimulator;
import prefuse.util.force.Spring;

public abstract class AbstractForce
implements Force {
    protected float[] params;
    protected float[] minValues;
    protected float[] maxValues;

    @Override
    public void init(ForceSimulator fSim) {
    }

    @Override
    public int getParameterCount() {
        return this.params == null ? 0 : this.params.length;
    }

    @Override
    public float getParameter(int i) {
        if (i < 0 || this.params == null || i >= this.params.length) {
            throw new IndexOutOfBoundsException();
        }
        return this.params[i];
    }

    @Override
    public float getMinValue(int i) {
        if (i < 0 || this.params == null || i >= this.params.length) {
            throw new IndexOutOfBoundsException();
        }
        return this.minValues[i];
    }

    @Override
    public float getMaxValue(int i) {
        if (i < 0 || this.params == null || i >= this.params.length) {
            throw new IndexOutOfBoundsException();
        }
        return this.maxValues[i];
    }

    @Override
    public String getParameterName(int i) {
        String[] pNames = this.getParameterNames();
        if (i < 0 || pNames == null || i >= pNames.length) {
            throw new IndexOutOfBoundsException();
        }
        return pNames[i];
    }

    @Override
    public void setParameter(int i, float val) {
        if (i < 0 || this.params == null || i >= this.params.length) {
            throw new IndexOutOfBoundsException();
        }
        this.params[i] = val;
    }

    @Override
    public void setMinValue(int i, float val) {
        if (i < 0 || this.params == null || i >= this.params.length) {
            throw new IndexOutOfBoundsException();
        }
        this.minValues[i] = val;
    }

    @Override
    public void setMaxValue(int i, float val) {
        if (i < 0 || this.params == null || i >= this.params.length) {
            throw new IndexOutOfBoundsException();
        }
        this.maxValues[i] = val;
    }

    protected abstract String[] getParameterNames();

    @Override
    public boolean isItemForce() {
        return false;
    }

    @Override
    public boolean isSpringForce() {
        return false;
    }

    @Override
    public void getForce(ForceItem item) {
        throw new UnsupportedOperationException("This class does not support this operation");
    }

    @Override
    public void getForce(Spring spring) {
        throw new UnsupportedOperationException("This class does not support this operation");
    }
}

