/*
 * Decompiled with CFR 0.152.
 */
package prefuse.util.collections;

import java.util.Iterator;
import java.util.NoSuchElementException;

public class CompositeIterator
implements Iterator {
    private Iterator[] m_iterators;
    private int m_cur;

    public CompositeIterator(int size) {
        this.m_iterators = new Iterator[size];
    }

    public CompositeIterator(Iterator iter1, Iterator iter2) {
        this(new Iterator[]{iter1, iter2});
    }

    public CompositeIterator(Iterator[] iterators) {
        this.m_iterators = iterators;
        this.m_cur = 0;
    }

    public void setIterator(int idx, Iterator iter) {
        this.m_iterators[idx] = iter;
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }

    public Object next() {
        if (this.hasNext()) {
            return this.m_iterators[this.m_cur].next();
        }
        throw new NoSuchElementException();
    }

    @Override
    public boolean hasNext() {
        if (this.m_iterators == null) {
            return false;
        }
        while (true) {
            if (this.m_cur >= this.m_iterators.length) {
                this.m_iterators = null;
                return false;
            }
            if (this.m_iterators[this.m_cur] == null) {
                ++this.m_cur;
                continue;
            }
            if (this.m_iterators[this.m_cur].hasNext()) {
                return true;
            }
            ++this.m_cur;
        }
    }
}

