/*
 * Decompiled with CFR 0.152.
 */
package prefuse.util.collections;

import java.util.NoSuchElementException;
import prefuse.util.collections.IntIterator;

public class CompositeIntIterator
extends IntIterator {
    private IntIterator[] m_iterators;
    private int m_cur;

    public CompositeIntIterator(IntIterator iter1, IntIterator iter2) {
        this(new IntIterator[]{iter1, iter2});
    }

    public CompositeIntIterator(IntIterator[] iterators) {
        this.m_iterators = iterators;
        this.m_cur = 0;
    }

    @Override
    public int nextInt() {
        if (this.hasNext()) {
            return this.m_iterators[this.m_cur].nextInt();
        }
        throw new NoSuchElementException();
    }

    @Override
    public boolean hasNext() {
        if (this.m_iterators == null) {
            return false;
        }
        do {
            if (!this.m_iterators[this.m_cur].hasNext()) continue;
            return true;
        } while (++this.m_cur < this.m_iterators.length);
        this.m_iterators = null;
        return false;
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }
}

