/*
 * Decompiled with CFR 0.152.
 */
package prefuse.util.collections;

import java.io.ByteArrayInputStream;
import java.io.InputStream;

public class ByteArrayList {
    private byte[] m_bytes;
    private int m_size;

    public ByteArrayList() {
        this(4096);
    }

    public ByteArrayList(int capacity) {
        this.m_bytes = new byte[capacity];
        this.m_size = 0;
    }

    private void rangeCheck(int i) {
        if (i < 0 || i >= this.m_size) {
            throw new IndexOutOfBoundsException("Index: " + i + " Size: " + this.m_size);
        }
    }

    private void ensureCapacity(int cap) {
        if (this.m_bytes.length < cap) {
            int capacity = Math.max(3 * this.m_bytes.length / 2 + 1, cap);
            byte[] nBytes = new byte[capacity];
            System.arraycopy(this.m_bytes, 0, nBytes, 0, this.m_size);
            this.m_bytes = nBytes;
        }
    }

    public byte get(int i) {
        this.rangeCheck(i);
        return this.m_bytes[i];
    }

    public void set(int i, byte b) {
        this.rangeCheck(i);
        this.m_bytes[i] = b;
    }

    public int size() {
        return this.m_size;
    }

    public void add(byte b) {
        this.ensureCapacity(this.m_size + 1);
        this.m_bytes[this.m_size++] = b;
    }

    public void add(byte[] b, int start, int len) {
        this.ensureCapacity(this.m_size + len);
        System.arraycopy(b, start, this.m_bytes, this.m_size, len);
        this.m_size += len;
    }

    public InputStream getAsInputStream() {
        return new ByteArrayInputStream(this.m_bytes, 0, this.m_size);
    }

    public byte[] toArray() {
        byte[] b = new byte[this.m_size];
        System.arraycopy(this.m_bytes, 0, b, 0, this.m_size);
        return b;
    }
}

