/*
 * Decompiled with CFR 0.152.
 */
package prefuse.util;

import java.awt.BasicStroke;
import prefuse.util.collections.IntObjectHashMap;

public class StrokeLib {
    private static final IntObjectHashMap strokeMap = new IntObjectHashMap();
    private static int misses = 0;
    private static int lookups = 0;
    public static final float[] DOTS = new float[]{1.0f, 2.0f};
    public static final float[] DASHES = new float[]{5.0f, 5.0f};
    public static final float[] LONG_DASHES = new float[]{10.0f, 10.0f};

    public static BasicStroke getStroke(float width) {
        return StrokeLib.getStroke(width, 2, 0);
    }

    public static BasicStroke getStroke(float width, float[] dashes) {
        return StrokeLib.getStroke(width, 2, 0, 10.0f, dashes, 0.0f);
    }

    public static BasicStroke getStroke(float width, int cap, int join) {
        return StrokeLib.getStroke(width, cap, join, 10.0f, null, 0.0f);
    }

    public static BasicStroke getStroke(float width, int cap, int join, float miterLimit, float[] dashes, float dashPhase) {
        int key = StrokeLib.getStrokeKey(width, cap, join, miterLimit, dashes, dashPhase);
        BasicStroke s = (BasicStroke)strokeMap.get(key);
        if (s == null) {
            s = new BasicStroke(width, cap, join, miterLimit, dashes, dashPhase);
            strokeMap.put(key, s);
            ++misses;
        }
        ++lookups;
        return s;
    }

    protected static int getStrokeKey(float width, int cap, int join, float miterLimit, float[] dashes, float dashPhase) {
        int hash = Float.floatToIntBits(width);
        hash = hash * 31 + join;
        hash = hash * 31 + cap;
        hash = hash * 31 + Float.floatToIntBits(miterLimit);
        if (dashes != null) {
            hash = hash * 31 + Float.floatToIntBits(dashPhase);
            for (int i = 0; i < dashes.length; ++i) {
                hash = hash * 31 + Float.floatToIntBits(dashes[i]);
            }
        }
        return hash;
    }

    public static BasicStroke getDerivedStroke(BasicStroke s, float width) {
        if (s.getLineWidth() == width) {
            return s;
        }
        return StrokeLib.getStroke(width * s.getLineWidth(), s.getEndCap(), s.getLineJoin(), s.getMiterLimit(), s.getDashArray(), s.getDashPhase());
    }

    public static int getCacheMissCount() {
        return misses;
    }

    public static int getCacheLookupCount() {
        return lookups;
    }

    public static void clearCache() {
        strokeMap.clear();
    }
}

