/*
 * Decompiled with CFR 0.152.
 */
package prefuse.util;

import prefuse.data.Tuple;
import prefuse.data.expression.Expression;
import prefuse.data.expression.IfExpression;
import prefuse.data.expression.ObjectLiteral;
import prefuse.data.expression.Predicate;

public class PredicateChain {
    private Expression m_head = new ObjectLiteral(null);
    private IfExpression m_tail = null;

    public Expression getExpression() {
        return this.m_head;
    }

    public Object get(Tuple t) {
        return this.m_head.get(t);
    }

    public void add(Predicate p, Object val) {
        if (this.m_tail == null) {
            this.m_tail = new IfExpression(p, new ObjectLiteral(val), this.m_head);
            this.m_head = this.m_tail;
        } else {
            IfExpression ie = new IfExpression(p, new ObjectLiteral(val), this.m_tail.getElseExpression());
            this.m_tail.setElseExpression(ie);
            this.m_tail = ie;
        }
    }

    public boolean remove(Predicate p) {
        if (p == null) {
            return false;
        }
        IfExpression prev = null;
        Expression expr = this.m_head;
        while (expr instanceof IfExpression) {
            IfExpression ifEx = (IfExpression)expr;
            Predicate test = ifEx.getTestPredicate();
            if (p.equals(test)) {
                Expression elseEx = ifEx.getElseExpression();
                ifEx.setElseExpression(new ObjectLiteral(null));
                if (prev != null) {
                    prev.setElseExpression(elseEx);
                    if (ifEx == this.m_tail) {
                        this.m_tail = prev;
                    }
                } else {
                    this.m_head = elseEx;
                    if (ifEx == this.m_tail) {
                        this.m_tail = null;
                    }
                }
                return true;
            }
            prev = ifEx;
            expr = ifEx.getElseExpression();
        }
        return false;
    }

    public void clear() {
        this.m_head = new ObjectLiteral(null);
        this.m_tail = null;
    }
}

