/*
 * Decompiled with CFR 0.152.
 */
package prefuse.render;

import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RectangularShape;
import java.awt.geom.RoundRectangle2D;
import prefuse.render.AbstractShapeRenderer;
import prefuse.render.ImageFactory;
import prefuse.util.ColorLib;
import prefuse.util.FontLib;
import prefuse.util.GraphicsLib;
import prefuse.util.StringLib;
import prefuse.visual.VisualItem;

public class LabelRenderer
extends AbstractShapeRenderer {
    protected ImageFactory m_images = null;
    protected String m_delim = "\n";
    protected String m_labelName = "label";
    protected String m_imageName = null;
    protected int m_xAlign = 2;
    protected int m_yAlign = 2;
    protected int m_hTextAlign = 2;
    protected int m_vTextAlign = 2;
    protected int m_hImageAlign = 2;
    protected int m_vImageAlign = 2;
    protected int m_imagePos = 0;
    protected int m_horizBorder = 2;
    protected int m_vertBorder = 0;
    protected int m_imageMargin = 2;
    protected int m_arcWidth = 0;
    protected int m_arcHeight = 0;
    protected int m_maxTextWidth = -1;
    AffineTransform m_transform = new AffineTransform();
    protected RectangularShape m_bbox = new Rectangle2D.Double();
    protected Point2D m_pt = new Point2D.Double();
    protected Font m_font;
    protected String m_text;
    protected Dimension m_textDim = new Dimension();

    public LabelRenderer() {
    }

    public LabelRenderer(String textField) {
        this.setTextField(textField);
    }

    public LabelRenderer(String textField, String imageField) {
        this.setTextField(textField);
        this.setImageField(imageField);
    }

    public void setRoundedCorner(int arcWidth, int arcHeight) {
        if (!(arcWidth != 0 && arcHeight != 0 || this.m_bbox instanceof Rectangle2D)) {
            this.m_bbox = new Rectangle2D.Double();
        } else {
            if (!(this.m_bbox instanceof RoundRectangle2D)) {
                this.m_bbox = new RoundRectangle2D.Double();
            }
            ((RoundRectangle2D)this.m_bbox).setRoundRect(0.0, 0.0, 10.0, 10.0, arcWidth, arcHeight);
            this.m_arcWidth = arcWidth;
            this.m_arcHeight = arcHeight;
        }
    }

    public String getTextField() {
        return this.m_labelName;
    }

    public void setTextField(String textField) {
        this.m_labelName = textField;
    }

    public void setMaxTextWidth(int maxWidth) {
        this.m_maxTextWidth = maxWidth;
    }

    protected String getText(VisualItem item) {
        String s = null;
        if (item.canGetString(this.m_labelName)) {
            return item.getString(this.m_labelName);
        }
        return s;
    }

    public String getImageField() {
        return this.m_imageName;
    }

    public void setImageField(String imageField) {
        if (imageField != null) {
            this.m_images = new ImageFactory();
        }
        this.m_imageName = imageField;
    }

    public void setMaxImageDimensions(int width, int height) {
        if (this.m_images == null) {
            this.m_images = new ImageFactory();
        }
        this.m_images.setMaxImageDimensions(width, height);
    }

    protected String getImageLocation(VisualItem item) {
        return item.canGetString(this.m_imageName) ? item.getString(this.m_imageName) : null;
    }

    protected Image getImage(VisualItem item) {
        String imageLoc = this.getImageLocation(item);
        return imageLoc == null ? null : this.m_images.getImage(imageLoc);
    }

    private String computeTextDimensions(VisualItem item, String text, double size) {
        String line;
        this.m_font = item.getFont();
        if (size != 1.0) {
            this.m_font = FontLib.getFont(this.m_font.getName(), this.m_font.getStyle(), size * (double)this.m_font.getSize());
        }
        FontMetrics fm = DEFAULT_GRAPHICS.getFontMetrics(this.m_font);
        StringBuffer str = null;
        int nlines = 1;
        int w = 0;
        int start = 0;
        int end = text.indexOf(this.m_delim);
        this.m_textDim.width = 0;
        while (end >= 0) {
            line = text.substring(start, end);
            w = fm.stringWidth(line);
            if (this.m_maxTextWidth > -1 && w > this.m_maxTextWidth) {
                if (str == null) {
                    str = new StringBuffer(text.substring(0, start));
                }
                str.append(StringLib.abbreviate(line, fm, this.m_maxTextWidth));
                str.append(this.m_delim);
                w = this.m_maxTextWidth;
            } else if (str != null) {
                str.append(line).append(this.m_delim);
            }
            this.m_textDim.width = Math.max(this.m_textDim.width, w);
            start = end + 1;
            end = text.indexOf(this.m_delim, start);
            ++nlines;
        }
        line = text.substring(start);
        w = fm.stringWidth(line);
        if (this.m_maxTextWidth > -1 && w > this.m_maxTextWidth) {
            if (str == null) {
                str = new StringBuffer(text.substring(0, start));
            }
            str.append(StringLib.abbreviate(line, fm, this.m_maxTextWidth));
            w = this.m_maxTextWidth;
        } else if (str != null) {
            str.append(line);
        }
        this.m_textDim.width = Math.max(this.m_textDim.width, w);
        this.m_textDim.height = fm.getHeight() * nlines;
        return str == null ? text : str.toString();
    }

    @Override
    protected Shape getRawShape(VisualItem item) {
        this.m_text = this.getText(item);
        Image img = this.getImage(item);
        double size = item.getSize();
        double iw = 0.0;
        double ih = 0.0;
        if (img != null) {
            ih = img.getHeight(null);
            iw = img.getWidth(null);
        }
        int tw = 0;
        int th = 0;
        if (this.m_text != null) {
            this.m_text = this.computeTextDimensions(item, this.m_text, size);
            th = this.m_textDim.height;
            tw = this.m_textDim.width;
        }
        double w = 0.0;
        double h = 0.0;
        switch (this.m_imagePos) {
            case 0: 
            case 1: {
                w = (double)tw + size * (iw + (double)(2 * this.m_horizBorder) + (double)(tw > 0 && iw > 0.0 ? this.m_imageMargin : 0));
                h = Math.max((double)th, size * ih) + size * 2.0 * (double)this.m_vertBorder;
                break;
            }
            case 3: 
            case 4: {
                w = Math.max((double)tw, size * iw) + size * 2.0 * (double)this.m_horizBorder;
                h = (double)th + size * (ih + (double)(2 * this.m_vertBorder) + (double)(th > 0 && ih > 0.0 ? this.m_imageMargin : 0));
                break;
            }
            default: {
                throw new IllegalStateException("Unrecognized image alignment setting.");
            }
        }
        LabelRenderer.getAlignedPoint(this.m_pt, item, w, h, this.m_xAlign, this.m_yAlign);
        if (this.m_bbox instanceof RoundRectangle2D) {
            RoundRectangle2D rr = (RoundRectangle2D)this.m_bbox;
            rr.setRoundRect(this.m_pt.getX(), this.m_pt.getY(), w, h, size * (double)this.m_arcWidth, size * (double)this.m_arcHeight);
        } else {
            this.m_bbox.setFrame(this.m_pt.getX(), this.m_pt.getY(), w, h);
        }
        return this.m_bbox;
    }

    protected static void getAlignedPoint(Point2D p, VisualItem item, double w, double h, int xAlign, int yAlign) {
        double x = item.getX();
        double y = item.getY();
        if (Double.isNaN(x) || Double.isInfinite(x)) {
            x = 0.0;
        }
        if (Double.isNaN(y) || Double.isInfinite(y)) {
            y = 0.0;
        }
        if (xAlign == 2) {
            x -= w / 2.0;
        } else if (xAlign == 1) {
            x -= w;
        }
        if (yAlign == 2) {
            y -= h / 2.0;
        } else if (yAlign == 3) {
            y -= h;
        }
        p.setLocation(x, y);
    }

    @Override
    public void render(Graphics2D g, VisualItem item) {
        RectangularShape shape = (RectangularShape)this.getShape(item);
        if (shape == null) {
            return;
        }
        int type = this.getRenderType(item);
        if (type == 2 || type == 3) {
            GraphicsLib.paint(g, item, shape, this.getStroke(item), 2);
        }
        String text = this.m_text;
        Image img = this.getImage(item);
        if (text == null && img == null) {
            return;
        }
        double size = item.getSize();
        boolean useInt = 1.5 > Math.max(g.getTransform().getScaleX(), g.getTransform().getScaleY());
        double x = shape.getMinX() + size * (double)this.m_horizBorder;
        double y = shape.getMinY() + size * (double)this.m_vertBorder;
        if (img != null) {
            double w = size * (double)img.getWidth(null);
            double h = size * (double)img.getHeight(null);
            double ix = x;
            double iy = y;
            switch (this.m_imagePos) {
                case 0: {
                    x += w + size * (double)this.m_imageMargin;
                    break;
                }
                case 1: {
                    ix = shape.getMaxX() - size * (double)this.m_horizBorder - w;
                    break;
                }
                case 4: {
                    y += h + size * (double)this.m_imageMargin;
                    break;
                }
                case 3: {
                    iy = shape.getMaxY() - size * (double)this.m_vertBorder - h;
                    break;
                }
                default: {
                    throw new IllegalStateException("Unrecognized image alignment setting.");
                }
            }
            block6 : switch (this.m_imagePos) {
                case 0: 
                case 1: {
                    switch (this.m_vImageAlign) {
                        case 4: {
                            break;
                        }
                        case 3: {
                            iy = shape.getMaxY() - size * (double)this.m_vertBorder - h;
                            break;
                        }
                        case 2: {
                            iy = shape.getCenterY() - h / 2.0;
                        }
                    }
                    break;
                }
                case 3: 
                case 4: {
                    switch (this.m_hImageAlign) {
                        case 0: {
                            break block6;
                        }
                        case 1: {
                            ix = shape.getMaxX() - size * (double)this.m_horizBorder - w;
                            break block6;
                        }
                        case 2: {
                            ix = shape.getCenterX() - w / 2.0;
                        }
                    }
                }
            }
            if (useInt && size == 1.0) {
                g.drawImage(img, (int)ix, (int)iy, null);
            } else {
                this.m_transform.setTransform(size, 0.0, 0.0, size, ix, iy);
                g.drawImage(img, this.m_transform, null);
            }
        }
        int textColor = item.getTextColor();
        if (text != null && ColorLib.alpha(textColor) > 0) {
            double th;
            double tw;
            g.setPaint(ColorLib.getColor(textColor));
            g.setFont(this.m_font);
            FontMetrics fm = DEFAULT_GRAPHICS.getFontMetrics(this.m_font);
            switch (this.m_imagePos) {
                case 3: 
                case 4: {
                    tw = shape.getWidth() - 2.0 * size * (double)this.m_horizBorder;
                    break;
                }
                default: {
                    tw = this.m_textDim.width;
                }
            }
            switch (this.m_imagePos) {
                case 0: 
                case 1: {
                    th = shape.getHeight() - 2.0 * size * (double)this.m_vertBorder;
                    break;
                }
                default: {
                    th = this.m_textDim.height;
                }
            }
            y += (double)fm.getAscent();
            switch (this.m_vTextAlign) {
                case 4: {
                    break;
                }
                case 3: {
                    y += th - (double)this.m_textDim.height;
                    break;
                }
                case 2: {
                    y += (th - (double)this.m_textDim.height) / 2.0;
                }
            }
            int lh = fm.getHeight();
            int start = 0;
            int end = text.indexOf(this.m_delim);
            while (end >= 0) {
                this.drawString(g, fm, text.substring(start, end), useInt, x, y, tw);
                start = end + 1;
                end = text.indexOf(this.m_delim, start);
                y += (double)lh;
            }
            this.drawString(g, fm, text.substring(start), useInt, x, y, tw);
        }
        if (type == 1 || type == 3) {
            GraphicsLib.paint(g, item, shape, this.getStroke(item), 1);
        }
    }

    private final void drawString(Graphics2D g, FontMetrics fm, String text, boolean useInt, double x, double y, double w) {
        double tx;
        switch (this.m_hTextAlign) {
            case 0: {
                tx = x;
                break;
            }
            case 1: {
                tx = x + w - (double)fm.stringWidth(text);
                break;
            }
            case 2: {
                tx = x + (w - (double)fm.stringWidth(text)) / 2.0;
                break;
            }
            default: {
                throw new IllegalStateException("Unrecognized text alignment setting.");
            }
        }
        if (useInt) {
            g.drawString(text, (int)tx, (int)y);
        } else {
            g.drawString(text, (float)tx, (float)y);
        }
    }

    public ImageFactory getImageFactory() {
        if (this.m_images == null) {
            this.m_images = new ImageFactory();
        }
        return this.m_images;
    }

    public void setImageFactory(ImageFactory ifact) {
        this.m_images = ifact;
    }

    public int getHorizontalTextAlignment() {
        return this.m_hTextAlign;
    }

    public void setHorizontalTextAlignment(int halign) {
        if (halign != 0 && halign != 1 && halign != 2) {
            throw new IllegalArgumentException("Illegal horizontal text alignment value.");
        }
        this.m_hTextAlign = halign;
    }

    public int getVerticalTextAlignment() {
        return this.m_vTextAlign;
    }

    public void setVerticalTextAlignment(int valign) {
        if (valign != 4 && valign != 3 && valign != 2) {
            throw new IllegalArgumentException("Illegal vertical text alignment value.");
        }
        this.m_vTextAlign = valign;
    }

    public int getHorizontalImageAlignment() {
        return this.m_hImageAlign;
    }

    public void setHorizontalImageAlignment(int halign) {
        if (halign != 0 && halign != 1 && halign != 2) {
            throw new IllegalArgumentException("Illegal horizontal text alignment value.");
        }
        this.m_hImageAlign = halign;
    }

    public int getVerticalImageAlignment() {
        return this.m_vImageAlign;
    }

    public void setVerticalImageAlignment(int valign) {
        if (valign != 4 && valign != 3 && valign != 2) {
            throw new IllegalArgumentException("Illegal vertical text alignment value.");
        }
        this.m_vImageAlign = valign;
    }

    public int getImagePosition() {
        return this.m_imagePos;
    }

    public void setImagePosition(int pos) {
        if (pos != 4 && pos != 3 && pos != 0 && pos != 1 && pos != 2) {
            throw new IllegalArgumentException("Illegal image position value.");
        }
        this.m_imagePos = pos;
    }

    public int getHorizontalAlignment() {
        return this.m_xAlign;
    }

    public int getVerticalAlignment() {
        return this.m_yAlign;
    }

    public void setHorizontalAlignment(int align) {
        this.m_xAlign = align;
    }

    public void setVerticalAlignment(int align) {
        this.m_yAlign = align;
    }

    public int getHorizontalPadding() {
        return this.m_horizBorder;
    }

    public void setHorizontalPadding(int xpad) {
        this.m_horizBorder = xpad;
    }

    public int getVerticalPadding() {
        return this.m_vertBorder;
    }

    public void setVerticalPadding(int ypad) {
        this.m_vertBorder = ypad;
    }

    public int getImageTextPadding() {
        return this.m_imageMargin;
    }

    public void setImageTextPadding(int pad) {
        this.m_imageMargin = pad;
    }
}

