/*
 * Decompiled with CFR 0.152.
 */
package prefuse.data.util;

import java.util.ConcurrentModificationException;
import java.util.Date;
import prefuse.data.Table;
import prefuse.util.collections.IntIterator;

public class TableIterator
extends IntIterator {
    private Table m_table;
    private IntIterator m_rows;
    private int m_modCount;
    protected int m_cur = -1;

    public TableIterator(Table table, IntIterator rows) {
        this.m_table = table;
        this.m_rows = rows;
        this.m_modCount = table.getModificationCount();
    }

    @Override
    public int nextInt() {
        if (this.m_modCount != this.m_table.getModificationCount()) {
            throw new ConcurrentModificationException();
        }
        this.m_cur = this.m_rows.nextInt();
        return this.m_cur;
    }

    @Override
    public boolean hasNext() {
        return this.m_rows.hasNext();
    }

    @Override
    public void remove() {
        if (this.m_table.removeRow(this.m_cur)) {
            this.modify();
        }
    }

    protected void modify() {
        ++this.m_modCount;
        this.m_cur = -1;
    }

    public final boolean canGet(String field, Class type) {
        return this.m_table.canGet(field, type);
    }

    public final boolean canSet(String field, Class type) {
        return this.m_table.canSet(field, type);
    }

    public final Object get(String field) {
        return this.m_table.get(this.m_cur, field);
    }

    public final void set(String field, Object val) {
        ++this.m_modCount;
        this.m_table.set(this.m_cur, field, val);
    }

    public final boolean canGetInt(String field) {
        return this.m_table.canGetInt(field);
    }

    public final boolean canSetInt(String field) {
        return this.m_table.canSetInt(field);
    }

    public final int getInt(String field) {
        return this.m_table.getInt(this.m_cur, field);
    }

    public final void setInt(String field, int val) {
        ++this.m_modCount;
        this.m_table.setInt(this.m_cur, field, val);
    }

    public final boolean canGetLong(String field) {
        return this.m_table.canGetLong(field);
    }

    public final boolean canSetLong(String field) {
        return this.m_table.canSetLong(field);
    }

    public final long getLong(String field) {
        return this.m_table.getLong(this.m_cur, field);
    }

    public final void setLong(String field, long val) {
        ++this.m_modCount;
        this.m_table.setLong(this.m_cur, field, val);
    }

    public final boolean canGetFloat(String field) {
        return this.m_table.canGetFloat(field);
    }

    public final boolean canSetFloat(String field) {
        return this.m_table.canSetFloat(field);
    }

    public final float getFloat(String field) {
        return this.m_table.getFloat(this.m_cur, field);
    }

    public final void setFloat(String field, float val) {
        ++this.m_modCount;
        this.m_table.setFloat(this.m_cur, field, val);
    }

    public final boolean canGetDouble(String field) {
        return this.m_table.canGetDouble(field);
    }

    public final boolean canSetDouble(String field) {
        return this.m_table.canSetDouble(field);
    }

    public final double getDouble(String field) {
        return this.m_table.getDouble(this.m_cur, field);
    }

    public final void setDouble(String field, double val) {
        ++this.m_modCount;
        this.m_table.setDouble(this.m_cur, field, val);
    }

    public final boolean canGetBoolean(String field) {
        return this.m_table.canGetBoolean(field);
    }

    public final boolean canSetBoolean(String field) {
        return this.m_table.canSetBoolean(field);
    }

    public final boolean getBoolean(String field) {
        return this.m_table.getBoolean(this.m_cur, field);
    }

    public final void setBoolean(String field, boolean val) {
        ++this.m_modCount;
        this.m_table.setBoolean(this.m_cur, field, val);
    }

    public final boolean canGetString(String field) {
        return this.m_table.canGetString(field);
    }

    public final boolean canSetString(String field) {
        return this.m_table.canSetString(field);
    }

    public final String getString(String field) {
        return this.m_table.getString(this.m_cur, field);
    }

    public final void setString(String field, String val) {
        ++this.m_modCount;
        this.m_table.setString(this.m_cur, field, val);
    }

    public final boolean canGetDate(String field) {
        return this.m_table.canGetDate(field);
    }

    public final boolean canSetDate(String field) {
        return this.m_table.canSetDate(field);
    }

    public final Date getDate(String field) {
        return this.m_table.getDate(this.m_cur, field);
    }

    public final void setDate(String field, Date val) {
        ++this.m_modCount;
        this.m_table.setDate(this.m_cur, field, val);
    }
}

