/*
 * Decompiled with CFR 0.152.
 */
package prefuse.data.util;

import prefuse.data.Table;
import prefuse.util.collections.IntIntSortedMap;
import prefuse.util.collections.IntIntTreeMap;
import prefuse.util.collections.IntIterator;

public class RowManager {
    protected Table m_table;
    private IntIntSortedMap m_openRows;
    private int m_firstId = 0;
    private int m_curId = -1;

    public RowManager(Table table) {
        this.m_table = table;
    }

    public Table getTable() {
        return this.m_table;
    }

    public int getMinimumRow() {
        return this.m_firstId;
    }

    public int getMaximumRow() {
        return this.m_curId;
    }

    public int getRowCount() {
        return 1 + this.m_curId - this.m_firstId - (this.m_openRows == null ? 0 : this.m_openRows.size());
    }

    public boolean isValidRow(int row) {
        return row >= this.m_firstId && row <= this.m_curId && (this.m_openRows == null || !this.m_openRows.containsKey(row));
    }

    public void clear() {
        this.m_openRows = null;
        this.m_firstId = 0;
        this.m_curId = -1;
    }

    public int addRow() {
        int r;
        if (this.m_openRows == null || this.m_openRows.isEmpty()) {
            r = this.m_firstId == 0 ? (this.m_curId = this.m_curId + 1) : (this.m_firstId = this.m_firstId - 1);
        } else {
            int key = this.m_openRows.firstKey();
            r = this.m_openRows.remove(key);
        }
        return r;
    }

    public boolean releaseRow(int row) {
        if (row < 0) {
            return false;
        }
        if (this.m_openRows != null && this.m_openRows.containsKey(row)) {
            return false;
        }
        if (row == this.m_curId) {
            --this.m_curId;
        } else if (row == this.m_firstId) {
            ++this.m_firstId;
        } else {
            if (this.m_openRows == null) {
                this.m_openRows = new IntIntTreeMap(false);
            }
            this.m_openRows.put(row, row);
        }
        return true;
    }

    public int getColumnRow(int row, int col) {
        return this.isValidRow(row) ? row : -1;
    }

    public int getTableRow(int columnRow, int col) {
        return this.isValidRow(columnRow) ? columnRow : -1;
    }

    public IntIterator columnRows(int col) {
        return new ColumnRowIterator(this.rows(), col);
    }

    public IntIterator columnRows(int col, boolean reverse) {
        return new ColumnRowIterator(this.rows(reverse), col);
    }

    public IntIterator columnRows(IntIterator rows, int col) {
        return new ColumnRowIterator(rows, col);
    }

    public IntIterator rows() {
        return new RowIterator(false);
    }

    public IntIterator rows(boolean reverse) {
        return new RowIterator(reverse);
    }

    public class ColumnRowIterator
    extends IntIterator {
        private IntIterator rows;
        private int row;
        private int col;

        public ColumnRowIterator(IntIterator rows, int col) {
            this.rows = rows;
            this.col = col;
        }

        @Override
        public boolean hasNext() {
            return this.rows.hasNext();
        }

        @Override
        public int nextInt() {
            this.row = this.rows.nextInt();
            return RowManager.this.getColumnRow(this.row, this.col);
        }

        @Override
        public void remove() {
            RowManager.this.m_table.removeRow(this.row);
        }
    }

    public class RowIterator
    extends IntIterator {
        boolean reverse;
        int last = -1;
        int next;

        public RowIterator(boolean reverse) {
            this.reverse = reverse;
            this.next = this.advance(reverse ? RowManager.this.m_curId : RowManager.this.m_firstId);
        }

        @Override
        public boolean hasNext() {
            return this.reverse ? this.next >= 0 : this.next <= RowManager.this.m_curId;
        }

        @Override
        public int nextInt() {
            this.last = this.next;
            this.next = this.advance(this.reverse ? (this.next = this.next - 1) : (this.next = this.next + 1));
            return this.last;
        }

        @Override
        public void remove() {
            RowManager.this.m_table.removeRow(this.last);
        }

        private final int advance(int idx) {
            if (RowManager.this.m_openRows == null) {
                return idx;
            }
            if (this.reverse) {
                while (idx >= 0 && RowManager.this.m_openRows.containsKey(idx)) {
                    --idx;
                }
            } else {
                while (idx <= RowManager.this.m_curId && RowManager.this.m_openRows.containsKey(idx)) {
                    ++idx;
                }
            }
            return idx;
        }
    }
}

