/*
 * Decompiled with CFR 0.152.
 */
package prefuse.data.util;

import java.util.Iterator;
import prefuse.data.Edge;
import prefuse.data.Node;
import prefuse.data.Tuple;
import prefuse.util.collections.Queue;

public class BreadthFirstIterator
implements Iterator {
    protected Queue m_queue = new Queue();
    protected int m_depth;
    protected int m_traversal;
    protected boolean m_includeNodes;
    protected boolean m_includeEdges;

    public BreadthFirstIterator() {
    }

    public BreadthFirstIterator(Node n, int depth, int traversal) {
        this.init(new Node[]{n}, depth, traversal);
    }

    public BreadthFirstIterator(Iterator it, int depth, int traversal) {
        this.init(it, depth, traversal);
    }

    public void init(Object o, int depth, int traversal) {
        this.m_queue.clear();
        this.m_depth = depth;
        if (traversal < 0 || traversal >= 3) {
            throw new IllegalArgumentException("Unrecognized traversal type: " + traversal);
        }
        this.m_traversal = traversal;
        this.m_includeNodes = traversal == 0 || traversal == 2;
        boolean bl = this.m_includeEdges = traversal == 1 || traversal == 2;
        if (this.m_includeNodes) {
            if (o instanceof Node) {
                this.m_queue.add(o, 0);
            } else {
                Iterator tuples = (Iterator)o;
                while (tuples.hasNext()) {
                    this.m_queue.add(tuples.next(), 0);
                }
            }
        } else if (o instanceof Node) {
            Node n = (Node)o;
            this.m_queue.visit(n, 0);
            Iterator edges = this.getEdges(n);
            while (edges.hasNext()) {
                Edge e = (Edge)edges.next();
                Node nn = e.getAdjacentNode(n);
                this.m_queue.visit(nn, 1);
                if (this.m_queue.getDepth(e) >= 0) continue;
                this.m_queue.add(e, 1);
            }
        } else {
            Iterator tuples = (Iterator)o;
            while (tuples.hasNext()) {
                Node n = (Node)tuples.next();
                this.m_queue.visit(n, 0);
                Iterator edges = this.getEdges(n);
                while (edges.hasNext()) {
                    Edge e = (Edge)edges.next();
                    Node nn = e.getAdjacentNode(n);
                    this.m_queue.visit(nn, 1);
                    if (this.m_queue.getDepth(e) >= 0) continue;
                    this.m_queue.add(e, 1);
                }
            }
        }
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean hasNext() {
        return !this.m_queue.isEmpty();
    }

    protected Iterator getEdges(Node n) {
        return n.edges();
    }

    public int getDepth(Tuple t) {
        return this.m_queue.getDepth(t);
    }

    public Object next() {
        Tuple t = (Tuple)this.m_queue.removeFirst();
        switch (this.m_traversal) {
            case 0: 
            case 2: {
                if (t instanceof Edge) {
                    return t;
                }
                Node n = (Node)t;
                int d = this.m_queue.getDepth(n);
                if (d < this.m_depth) {
                    int dd = d + 1;
                    Iterator edges = this.getEdges(n);
                    while (edges.hasNext()) {
                        Edge e = (Edge)edges.next();
                        Node v = e.getAdjacentNode(n);
                        if (this.m_includeEdges && this.m_queue.getDepth(e) < 0) {
                            this.m_queue.add(e, dd);
                        }
                        if (this.m_queue.getDepth(v) >= 0) continue;
                        this.m_queue.add(v, dd);
                    }
                } else if (this.m_includeEdges && d == this.m_depth) {
                    Iterator edges = this.getEdges(n);
                    while (edges.hasNext()) {
                        Edge e = (Edge)edges.next();
                        Node v = e.getAdjacentNode(n);
                        int dv = this.m_queue.getDepth(v);
                        if (dv <= 0 || this.m_queue.getDepth(e) >= 0) continue;
                        this.m_queue.add(e, Math.min(d, dv));
                    }
                }
                return n;
            }
            case 1: {
                Edge e = (Edge)t;
                Node u = e.getSourceNode();
                Node v = e.getTargetNode();
                int du = this.m_queue.getDepth(u);
                int dv = this.m_queue.getDepth(v);
                if (du != dv) {
                    Node n = dv > du ? v : u;
                    int d = Math.max(du, dv);
                    if (d < this.m_depth) {
                        int dd = d + 1;
                        Iterator edges = this.getEdges(n);
                        while (edges.hasNext()) {
                            Edge ee = (Edge)edges.next();
                            if (this.m_queue.getDepth(ee) >= 0) continue;
                            Node nn = ee.getAdjacentNode(n);
                            this.m_queue.visit(nn, dd);
                            this.m_queue.add(ee, dd);
                        }
                    }
                }
                return e;
            }
        }
        throw new IllegalStateException();
    }
}

