/*
 * Decompiled with CFR 0.152.
 */
package prefuse.data.util;

import prefuse.data.event.ProjectionListener;
import prefuse.data.util.ColumnProjection;
import prefuse.util.collections.CopyOnWriteArrayList;

public abstract class AbstractColumnProjection
implements ColumnProjection {
    private CopyOnWriteArrayList m_listeners;

    @Override
    public void addProjectionListener(ProjectionListener listener) {
        if (this.m_listeners == null) {
            this.m_listeners = new CopyOnWriteArrayList();
        }
        if (!this.m_listeners.contains(listener)) {
            this.m_listeners.add(listener);
        }
    }

    @Override
    public void removeProjectionListener(ProjectionListener listener) {
        if (this.m_listeners != null) {
            this.m_listeners.remove(listener);
            if (this.m_listeners.size() == 0) {
                this.m_listeners = null;
            }
        }
    }

    public void fireUpdate() {
        if (this.m_listeners == null) {
            return;
        }
        Object[] listeners = this.m_listeners.getArray();
        for (int i = 0; i < listeners.length; ++i) {
            ((ProjectionListener)listeners[i]).projectionChanged(this);
        }
    }
}

