/*
 * Decompiled with CFR 0.152.
 */
package prefuse.data.query;

import javax.swing.JComponent;
import prefuse.data.Tuple;
import prefuse.data.event.TupleSetListener;
import prefuse.data.expression.AbstractPredicate;
import prefuse.data.query.DynamicQueryBinding;
import prefuse.data.search.PrefixSearchTupleSet;
import prefuse.data.search.SearchTupleSet;
import prefuse.data.tuple.TupleSet;
import prefuse.util.ui.JSearchPanel;
import prefuse.visual.VisualTupleSet;

public class SearchQueryBinding
extends DynamicQueryBinding {
    private SearchTupleSet m_set;
    private Listener m_listener = new Listener();
    private Object m_lock;

    public SearchQueryBinding(TupleSet ts, String field) {
        this(ts, field, new PrefixSearchTupleSet());
    }

    public SearchQueryBinding(TupleSet ts, String field, SearchTupleSet set) {
        super(ts, field);
        this.setPredicate(new SearchBindingPredicate());
        this.m_set = set;
        this.m_set.index(ts.tuples(), field);
        this.m_set.addTupleSetListener(this.m_listener);
        if (ts instanceof VisualTupleSet) {
            this.m_lock = ((VisualTupleSet)ts).getVisualization();
        }
    }

    public SearchTupleSet getSearchSet() {
        return this.m_set;
    }

    @Override
    public JComponent createComponent() {
        return this.createSearchPanel();
    }

    public JSearchPanel createSearchPanel() {
        return this.createSearchPanel(this.m_set instanceof PrefixSearchTupleSet);
    }

    public JSearchPanel createSearchPanel(boolean monitorKeystrokes) {
        JSearchPanel jsp = new JSearchPanel(this.m_set, this.m_field, monitorKeystrokes);
        if (this.m_lock != null) {
            jsp.setLock(this.m_lock);
        }
        return jsp;
    }

    private class Listener
    implements TupleSetListener {
        private Listener() {
        }

        @Override
        public void tupleSetChanged(TupleSet tSet, Tuple[] added, Tuple[] removed) {
            ((SearchBindingPredicate)SearchQueryBinding.this.getPredicate()).touch();
        }
    }

    private class SearchBindingPredicate
    extends AbstractPredicate {
        private SearchBindingPredicate() {
        }

        @Override
        public boolean getBoolean(Tuple t) {
            String q = SearchQueryBinding.this.m_set.getQuery();
            return q == null || q.length() == 0 || SearchQueryBinding.this.m_set.containsTuple(t);
        }

        public void touch() {
            this.fireExpressionChange();
        }
    }
}

