/*
 * Decompiled with CFR 0.152.
 */
package prefuse.data.query;

import java.util.ArrayList;
import javax.swing.DefaultListSelectionModel;
import javax.swing.MutableComboBoxModel;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;
import prefuse.util.collections.CopyOnWriteArrayList;

public class ListModel
extends DefaultListSelectionModel
implements MutableComboBoxModel {
    private ArrayList m_items = new ArrayList();
    private CopyOnWriteArrayList m_listeners = new CopyOnWriteArrayList();

    public ListModel() {
    }

    public ListModel(Object[] items) {
        for (int i = 0; i < items.length; ++i) {
            this.m_items.add(items[i]);
        }
    }

    private boolean isMultipleSelection() {
        return this.getMaxSelectionIndex() - this.getMinSelectionIndex() > 0;
    }

    @Override
    public Object getSelectedItem() {
        int idx = this.getMinSelectionIndex();
        return idx == -1 ? null : this.m_items.get(idx);
    }

    @Override
    public void setSelectedItem(Object item) {
        int idx = this.m_items.indexOf(item);
        if (idx < 0) {
            return;
        }
        if (!this.isMultipleSelection() && idx == this.getMinSelectionIndex()) {
            return;
        }
        super.setSelectionInterval(idx, idx);
        this.fireDataEvent(this, 0, -1, -1);
    }

    @Override
    public int getSize() {
        return this.m_items.size();
    }

    @Override
    public Object getElementAt(int idx) {
        return this.m_items.get(idx);
    }

    public void addElement(Object item) {
        this.m_items.add(item);
        int sz = this.m_items.size() - 1;
        this.fireDataEvent(this, 1, sz, sz);
        if (sz >= 0 && this.isSelectionEmpty() && item != null) {
            this.setSelectedItem(item);
        }
    }

    public void insertElementAt(Object item, int idx) {
        this.m_items.add(idx, item);
        this.fireDataEvent(this, 1, idx, idx);
    }

    @Override
    public void removeElement(Object item) {
        int idx = this.m_items.indexOf(item);
        if (idx >= 0) {
            this.removeElementAt(idx);
        }
    }

    @Override
    public void removeElementAt(int idx) {
        if (!this.isMultipleSelection() && idx == this.getMinSelectionIndex()) {
            int sIdx = idx == 0 ? (this.getSize() == 1 ? -1 : idx + 1) : idx - 1;
            Object sel = sIdx == -1 ? null : this.m_items.get(sIdx);
            this.setSelectedItem(sel);
        }
        this.m_items.remove(idx);
        this.fireDataEvent(this, 2, idx, idx);
    }

    @Override
    public void addListDataListener(ListDataListener l) {
        if (!this.m_listeners.contains(l)) {
            this.m_listeners.add(l);
        }
    }

    @Override
    public void removeListDataListener(ListDataListener l) {
        this.m_listeners.remove(l);
    }

    protected void fireDataEvent(Object src, int type, int idx0, int idx1) {
        Object[] listeners = this.m_listeners.getArray();
        if (listeners.length > 0) {
            ListDataEvent e = new ListDataEvent(src, type, idx0, idx1);
            for (int i = 0; i < listeners.length; ++i) {
                ((ListDataListener)listeners[i]).contentsChanged(e);
            }
        }
    }
}

