/*
 * Decompiled with CFR 0.152.
 */
package prefuse.data.parser;

import java.util.StringTokenizer;
import prefuse.data.parser.DataParseException;
import prefuse.data.parser.DataParser;
import prefuse.data.parser.LongParser;

public class LongArrayParser
implements DataParser {
    @Override
    public Class getType() {
        return long[].class;
    }

    @Override
    public String format(Object value) {
        if (value == null) {
            return null;
        }
        if (!(value instanceof long[])) {
            throw new IllegalArgumentException("This class can only format Objects of type long[].");
        }
        long[] values = (long[])value;
        StringBuffer sBuf = new StringBuffer();
        sBuf.append('[');
        for (int i = 0; i < values.length; ++i) {
            if (i > 0) {
                sBuf.append(", ");
            }
            sBuf.append(values[i]).append('L');
        }
        sBuf.append(']');
        return sBuf.toString();
    }

    @Override
    public boolean canParse(String text) {
        try {
            StringTokenizer st = new StringTokenizer(text, "\"[](){}, ");
            while (st.hasMoreTokens()) {
                LongParser.parseLong(st.nextToken());
            }
            return true;
        }
        catch (DataParseException e) {
            return false;
        }
    }

    @Override
    public Object parse(String text) throws DataParseException {
        try {
            StringTokenizer st = new StringTokenizer(text, "\"[](){}, ");
            long[] array = new long[st.countTokens()];
            int i = 0;
            while (st.hasMoreTokens()) {
                String tok = st.nextToken();
                array[i] = LongParser.parseLong(tok);
                ++i;
            }
            return array;
        }
        catch (NumberFormatException e) {
            throw new DataParseException(e);
        }
    }
}

