/*
 * Decompiled with CFR 0.152.
 */
package prefuse.data.parser;

import java.util.StringTokenizer;
import prefuse.data.parser.DataParseException;
import prefuse.data.parser.DataParser;

public class FloatArrayParser
implements DataParser {
    @Override
    public Class getType() {
        return float[].class;
    }

    @Override
    public String format(Object value) {
        if (value == null) {
            return null;
        }
        if (!(value instanceof float[])) {
            throw new IllegalArgumentException("This class can only format Objects of type float[].");
        }
        float[] values = (float[])value;
        StringBuffer sBuf = new StringBuffer();
        sBuf.append('[');
        for (int i = 0; i < values.length; ++i) {
            if (i > 0) {
                sBuf.append(", ");
            }
            sBuf.append(values[i]).append('f');
        }
        sBuf.append(']');
        return sBuf.toString();
    }

    @Override
    public boolean canParse(String text) {
        try {
            StringTokenizer st = new StringTokenizer(text, "\"[](){}, ");
            while (st.hasMoreTokens()) {
                Float.parseFloat(st.nextToken());
            }
            return true;
        }
        catch (NumberFormatException e) {
            return false;
        }
    }

    @Override
    public Object parse(String text) throws DataParseException {
        try {
            StringTokenizer st = new StringTokenizer(text, "\"[](){}, ");
            float[] array = new float[st.countTokens()];
            int i = 0;
            while (st.hasMoreTokens()) {
                String tok = st.nextToken();
                array[i] = Float.parseFloat(tok);
                ++i;
            }
            return array;
        }
        catch (NumberFormatException e) {
            throw new DataParseException(e);
        }
    }
}

