/*
 * Decompiled with CFR 0.152.
 */
package prefuse.data.parser;

import prefuse.data.parser.DataParseException;
import prefuse.data.parser.DataParser;

public class BooleanParser
implements DataParser {
    public static final String TRUE = "true";
    public static final String FALSE = "false";

    @Override
    public Class getType() {
        return Boolean.TYPE;
    }

    @Override
    public String format(Object value) {
        if (value == null) {
            return null;
        }
        if (!(value instanceof Boolean)) {
            throw new IllegalArgumentException("This class can only format Objects of type Boolean.");
        }
        return ((Boolean)value).toString();
    }

    @Override
    public boolean canParse(String text) {
        return TRUE.equalsIgnoreCase(text) || FALSE.equalsIgnoreCase(text);
    }

    @Override
    public Object parse(String text) throws DataParseException {
        return this.parseBoolean(text) ? Boolean.TRUE : Boolean.FALSE;
    }

    public boolean parseBoolean(String text) throws DataParseException {
        if (TRUE.equalsIgnoreCase(text)) {
            return true;
        }
        if (FALSE.equalsIgnoreCase(text)) {
            return false;
        }
        throw new DataParseException("Input does not represent a boolean value: " + text);
    }
}

