/*
 * Decompiled with CFR 0.152.
 */
package prefuse.data.io.sql;

import java.math.BigDecimal;
import java.sql.Array;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Ref;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Date;
import prefuse.data.Table;
import prefuse.data.io.sql.SQLDataHandler;

public class DefaultSQLDataHandler
implements SQLDataHandler {
    private boolean m_ignoreUnknownTypes;

    public DefaultSQLDataHandler() {
        this(true);
    }

    public DefaultSQLDataHandler(boolean ignoreUnknownTypes) {
        this.m_ignoreUnknownTypes = ignoreUnknownTypes;
    }

    public void setIgnoreUnknownTypes(boolean ignore) {
        this.m_ignoreUnknownTypes = ignore;
    }

    public boolean isIgnoreUnknownTypes() {
        return this.m_ignoreUnknownTypes;
    }

    @Override
    public void process(Table t, int trow, ResultSet rSet, int rCol) throws SQLException {
        ResultSetMetaData metadata = rSet.getMetaData();
        String field = metadata.getColumnName(rCol);
        int type = metadata.getColumnType(rCol);
        switch (type) {
            case 2003: {
                t.set(trow, field, (Object)rSet.getArray(rCol));
                break;
            }
            case -5: {
                t.setLong(trow, field, rSet.getLong(rCol));
                break;
            }
            case -4: 
            case -3: 
            case -2: {
                t.set(trow, field, (Object)rSet.getBytes(rCol));
                break;
            }
            case -7: 
            case 16: {
                t.setBoolean(trow, field, rSet.getBoolean(rCol));
                break;
            }
            case 2004: {
                t.set(trow, field, (Object)rSet.getBlob(rCol));
                break;
            }
            case -1: 
            case 1: 
            case 12: {
                t.setString(trow, field, rSet.getString(rCol));
                break;
            }
            case 2005: {
                t.set(trow, field, (Object)rSet.getClob(rCol));
                break;
            }
            case 91: {
                t.setDate(trow, field, (Date)rSet.getDate(rCol));
                break;
            }
            case 2: 
            case 3: 
            case 6: 
            case 8: {
                t.setDouble(trow, field, rSet.getDouble(rCol));
                break;
            }
            case -6: 
            case 4: 
            case 5: {
                t.setInt(trow, field, rSet.getInt(rCol));
                break;
            }
            case 2000: {
                t.set(trow, field, rSet.getObject(rCol));
                break;
            }
            case 7: {
                t.setFloat(trow, field, rSet.getFloat(rCol));
                break;
            }
            case 2006: {
                t.set(trow, field, (Object)rSet.getRef(rCol));
                break;
            }
            case 92: {
                t.setDate(trow, field, (Date)rSet.getTime(rCol));
                break;
            }
            case 93: {
                t.setDate(trow, field, (Date)rSet.getTimestamp(rCol));
                break;
            }
            default: {
                if (this.m_ignoreUnknownTypes) break;
                t.set(trow, field, rSet.getObject(rCol));
            }
        }
    }

    @Override
    public Class getDataType(String columnName, int sqlType) {
        switch (sqlType) {
            case 2003: {
                return Array.class;
            }
            case -5: {
                return Long.TYPE;
            }
            case -4: 
            case -3: 
            case -2: {
                return byte[].class;
            }
            case -7: 
            case 16: {
                return Boolean.TYPE;
            }
            case 2004: {
                return Blob.class;
            }
            case -1: 
            case 1: 
            case 12: {
                return String.class;
            }
            case 2005: {
                return Clob.class;
            }
            case 91: {
                return java.sql.Date.class;
            }
            case 2: 
            case 3: {
                return BigDecimal.class;
            }
            case 6: 
            case 8: {
                return Double.TYPE;
            }
            case -6: 
            case 4: 
            case 5: {
                return Integer.TYPE;
            }
            case 2000: {
                return Object.class;
            }
            case 7: {
                return Float.TYPE;
            }
            case 2006: {
                return Ref.class;
            }
            case 92: {
                return Time.class;
            }
            case 93: {
                return Timestamp.class;
            }
        }
        if (!this.m_ignoreUnknownTypes) {
            return Object.class;
        }
        return null;
    }
}

