/*
 * Decompiled with CFR 0.152.
 */
package prefuse.data.io.sql;

import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.HashMap;
import prefuse.data.Table;
import prefuse.data.io.sql.DefaultSQLDataHandler;
import prefuse.data.io.sql.SQLDataHandler;

public class CompositeSQLDataHandler
implements SQLDataHandler {
    private SQLDataHandler m_default;
    private HashMap m_overrides;

    public CompositeSQLDataHandler() {
        this(new DefaultSQLDataHandler());
    }

    public CompositeSQLDataHandler(SQLDataHandler defaultHandler) {
        this.m_default = defaultHandler;
    }

    public void addHandler(String columnName, SQLDataHandler handler) {
        if (this.m_overrides == null) {
            this.m_overrides = new HashMap(3);
        }
        this.m_overrides.put(columnName, handler);
    }

    public boolean removeHandler(String columnName) {
        if (this.m_overrides == null) {
            return false;
        }
        return this.m_overrides.remove(columnName) != null;
    }

    @Override
    public void process(Table t, int trow, ResultSet rSet, int rCol) throws SQLException {
        ResultSetMetaData metadata;
        String name;
        SQLDataHandler h;
        SQLDataHandler handler = this.m_default;
        if (this.m_overrides != null && this.m_overrides.size() > 0 && (h = (SQLDataHandler)this.m_overrides.get(name = (metadata = rSet.getMetaData()).getColumnName(rCol))) != null) {
            handler = h;
        }
        handler.process(t, trow, rSet, rCol);
    }

    @Override
    public Class getDataType(String columnName, int sqlType) {
        SQLDataHandler h;
        SQLDataHandler handler = this.m_default;
        if (this.m_overrides != null && this.m_overrides.size() > 0 && (h = (SQLDataHandler)this.m_overrides.get(columnName)) != null) {
            handler = h;
        }
        return handler.getDataType(columnName, sqlType);
    }
}

