/*
 * Decompiled with CFR 0.152.
 */
package prefuse.data.io;

import java.io.OutputStream;
import java.io.PrintWriter;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import prefuse.data.Edge;
import prefuse.data.Graph;
import prefuse.data.Node;
import prefuse.data.Schema;
import prefuse.data.io.AbstractGraphWriter;
import prefuse.data.io.DataIOException;
import prefuse.data.io.GraphMLReader;
import prefuse.util.io.XMLWriter;

public class GraphMLWriter
extends AbstractGraphWriter {
    private static final HashMap TYPES = new HashMap();

    @Override
    public void writeGraph(Graph graph, OutputStream os) throws DataIOException {
        Schema ns = graph.getNodeTable().getSchema();
        Schema es = graph.getEdgeTable().getSchema();
        this.checkGraphMLSchema(ns);
        this.checkGraphMLSchema(es);
        XMLWriter xml = new XMLWriter(new PrintWriter(os));
        xml.begin("<graphml xmlns=\"http://graphml.graphdrawing.org/xmlns\"\n  xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"\n  xsi:schemaLocation=\"http://graphml.graphdrawing.org/xmlns\n  http://graphml.graphdrawing.org/xmlns/1.0/graphml.xsd\">\n\n", 2);
        xml.comment("prefuse GraphML Writer | " + new Date(System.currentTimeMillis()));
        this.printSchema(xml, "node", ns, null);
        this.printSchema(xml, "edge", es, new String[]{graph.getEdgeSourceField(), graph.getEdgeTargetField()});
        xml.println();
        xml.start("graph", "edgedefault", graph.isDirected() ? "directed" : "undirected");
        xml.comment("nodes");
        Iterator nodes = graph.nodes();
        while (nodes.hasNext()) {
            Node n = (Node)nodes.next();
            if (ns.getColumnCount() > 0) {
                xml.start("node", "id", String.valueOf(n.getRow()));
                for (int i = 0; i < ns.getColumnCount(); ++i) {
                    String field = ns.getColumnName(i);
                    xml.contentTag("data", "key", field, n.getString(field));
                }
                xml.end();
                continue;
            }
            xml.tag("node", "id", String.valueOf(n.getRow()));
        }
        xml.println();
        String[] attr = new String[]{"id", "source", "target"};
        String[] vals = new String[3];
        xml.comment("edges");
        Iterator edges = graph.edges();
        while (edges.hasNext()) {
            Edge e = (Edge)edges.next();
            vals[0] = String.valueOf(e.getRow());
            vals[1] = String.valueOf(e.getSourceNode().getRow());
            vals[2] = String.valueOf(e.getTargetNode().getRow());
            if (es.getColumnCount() > 2) {
                xml.start("edge", attr, vals, 3);
                for (int i = 0; i < es.getColumnCount(); ++i) {
                    String field = es.getColumnName(i);
                    if (field.equals(graph.getEdgeSourceField()) || field.equals(graph.getEdgeTargetField())) continue;
                    xml.contentTag("data", "key", field, e.getString(field));
                }
                xml.end();
                continue;
            }
            xml.tag("edge", attr, vals, 3);
        }
        xml.end();
        xml.finish("</graphml>\n");
    }

    private void printSchema(XMLWriter xml, String group, Schema s, String[] ignore) {
        String[] attr = new String[]{"id", "for", "attr.name", "attr.type"};
        String[] vals = new String[4];
        block0: for (int i = 0; i < s.getColumnCount(); ++i) {
            vals[0] = s.getColumnName(i);
            for (int j = 0; ignore != null && j < ignore.length; ++j) {
                if (vals[0].equals(ignore[j])) continue block0;
            }
            vals[1] = group;
            vals[2] = vals[0];
            vals[3] = (String)TYPES.get(s.getColumnType(i));
            Object dFlt = s.getDefault(i);
            if (dFlt == null) {
                xml.tag("key", attr, vals, 4);
                continue;
            }
            xml.start("key", attr, vals, 4);
            xml.contentTag("default", dFlt.toString());
            xml.end();
        }
    }

    private void checkGraphMLSchema(Schema s) throws DataIOException {
        for (int i = 0; i < s.getColumnCount(); ++i) {
            Class type = s.getColumnType(i);
            if (TYPES.get(type) != null) continue;
            throw new DataIOException("Data type unsupported by the GraphML format: " + type.getName());
        }
    }

    static {
        TYPES.put(Integer.TYPE, "int");
        TYPES.put(Long.TYPE, "long");
        TYPES.put(Float.TYPE, "float");
        TYPES.put(Double.TYPE, "double");
        TYPES.put(Boolean.TYPE, "boolean");
        TYPES.put(String.class, "string");
    }

    public static interface Tokens
    extends GraphMLReader.Tokens {
        public static final String GRAPHML = "graphml";
        public static final String GRAPHML_HEADER = "<graphml xmlns=\"http://graphml.graphdrawing.org/xmlns\"\n  xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"\n  xsi:schemaLocation=\"http://graphml.graphdrawing.org/xmlns\n  http://graphml.graphdrawing.org/xmlns/1.0/graphml.xsd\">\n\n";
    }
}

