/*
 * Decompiled with CFR 0.152.
 */
package prefuse.data.io;

import java.io.BufferedOutputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import prefuse.data.Table;
import prefuse.data.io.AbstractTableWriter;
import prefuse.data.io.DataIOException;
import prefuse.data.io.FixedWidthTextTableSchema;
import prefuse.util.TypeLib;
import prefuse.util.collections.IntIterator;

public class FixedWidthTextTableWriter
extends AbstractTableWriter {
    private FixedWidthTextTableSchema m_schema;

    public FixedWidthTextTableWriter(FixedWidthTextTableSchema schema) {
        this.m_schema = schema;
    }

    public FixedWidthTextTableWriter(String location) throws DataIOException {
        this(FixedWidthTextTableSchema.load(location));
    }

    public FixedWidthTextTableSchema getFixedWidthSchema() {
        return this.m_schema;
    }

    public void setFixedWidthSchema(FixedWidthTextTableSchema schema) {
        this.m_schema = schema;
    }

    @Override
    public void writeTable(Table table, OutputStream os) throws DataIOException {
        try {
            PrintStream out = new PrintStream(new BufferedOutputStream(os));
            char[] pad = new char[table.getColumnCount()];
            boolean[] pre = new boolean[table.getColumnCount()];
            for (int i = 0; i < table.getColumnCount(); ++i) {
                Class type = table.getColumnType(i);
                pre[i] = TypeLib.isNumericType(type);
                pad[i] = pre[i] ? 48 : 32;
            }
            IntIterator rows = table.rows();
            while (rows.hasNext()) {
                int row = rows.nextInt();
                for (int i = 0; i < table.getColumnCount(); ++i) {
                    out.print(FixedWidthTextTableWriter.pack(table.getString(row, i), this.m_schema.getColumnLength(i), pre[i], pad[i]));
                }
                out.println();
            }
            out.flush();
        }
        catch (Exception e) {
            throw new DataIOException(e);
        }
    }

    private static String pack(String value, int len, boolean prepend, char pad) {
        int vLen = value.length();
        if (vLen < len) {
            StringBuffer sBuf = new StringBuffer();
            if (prepend) {
                sBuf.append(value);
            }
            for (int i = len; i < vLen; ++i) {
                sBuf.append(pad);
            }
            if (!prepend) {
                sBuf.append(value);
            }
            return sBuf.toString();
        }
        return value.substring(0, len);
    }
}

