/*
 * Decompiled with CFR 0.152.
 */
package prefuse.data.io;

import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PrintStream;
import prefuse.data.io.DataIOException;
import prefuse.util.io.IOLib;

public class FixedWidthTextTableSchema {
    private String[] names = new String[0];
    private int[] cols = new int[1];

    private void ensureCapacity(int cap) {
        String[] nNames = new String[this.names.length + 1];
        System.arraycopy(this.names, 0, nNames, 0, this.names.length);
        this.names = nNames;
        int[] nCols = new int[this.cols.length + 1];
        System.arraycopy(this.cols, 0, nCols, 0, this.cols.length);
        this.cols = nCols;
    }

    public void addColumn(String name, int length) {
        int idx = this.names.length;
        this.ensureCapacity(idx + 1);
        this.names[idx] = name;
        this.cols[idx + 1] = this.cols[idx] + length;
    }

    public int getColumnCount() {
        return this.names.length;
    }

    public String getColumnName(int idx) {
        return this.names[idx];
    }

    public int getColumnLength(int idx) {
        return this.cols[idx + 1] - this.cols[idx];
    }

    public int getColumnStart(int idx) {
        return this.cols[idx];
    }

    public int getColumnEnd(int idx) {
        return this.cols[idx + 1];
    }

    public void write(String filename) throws DataIOException {
        try {
            this.write(new FileOutputStream(filename));
        }
        catch (FileNotFoundException e) {
            throw new DataIOException(e);
        }
    }

    public void write(OutputStream os) throws DataIOException {
        try {
            PrintStream out = new PrintStream(new BufferedOutputStream(os));
            for (int i = 0; i < this.names.length; ++i) {
                out.print(this.names[i]);
                out.print('\t');
                out.print(this.cols[i + 1] - this.cols[i]);
                out.println();
            }
        }
        catch (Exception e) {
            throw new DataIOException(e);
        }
    }

    public static FixedWidthTextTableSchema load(String loc) throws DataIOException {
        try {
            String line;
            InputStream is = IOLib.streamFromString(loc);
            if (is == null) {
                return null;
            }
            FixedWidthTextTableSchema fws = new FixedWidthTextTableSchema();
            BufferedReader br = new BufferedReader(new InputStreamReader(is));
            while ((line = br.readLine()) != null) {
                String[] tok = line.split("\t");
                fws.addColumn(tok[0], Integer.parseInt(tok[1]));
            }
            return fws;
        }
        catch (Exception e) {
            throw new DataIOException(e);
        }
    }
}

