/*
 * Decompiled with CFR 0.152.
 */
package prefuse.data.io;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import prefuse.data.io.AbstractTextTableReader;
import prefuse.data.io.TableReadListener;
import prefuse.data.parser.DataParseException;
import prefuse.data.parser.ParserFactory;

public class DelimitedTextTableReader
extends AbstractTextTableReader {
    private String m_delim;

    public DelimitedTextTableReader() {
        this("\t");
    }

    public DelimitedTextTableReader(ParserFactory parserFactory) {
        this("\t", parserFactory);
    }

    public DelimitedTextTableReader(String delimiterRegex) {
        this.m_delim = delimiterRegex;
    }

    public DelimitedTextTableReader(String delimiterRegex, ParserFactory pf) {
        super(pf);
        this.m_delim = delimiterRegex;
    }

    @Override
    protected void read(InputStream is, TableReadListener trl) throws IOException, DataParseException {
        String line;
        int lineNo = 0;
        BufferedReader br = new BufferedReader(new InputStreamReader(is));
        while ((line = br.readLine()) != null) {
            ++lineNo;
            String[] cols = line.split(this.m_delim);
            for (int i = 0; i < cols.length; ++i) {
                trl.readValue(lineNo, i + 1, cols[i]);
            }
        }
    }
}

