/*
 * Decompiled with CFR 0.152.
 */
package prefuse.data.expression.parser;

public class TokenMgrError
extends Error {
    static final int LEXICAL_ERROR = 0;
    static final int STATIC_LEXER_ERROR = 1;
    static final int INVALID_LEXICAL_STATE = 2;
    static final int LOOP_DETECTED = 3;
    int errorCode;

    protected static final String addEscapes(String str) {
        StringBuffer retVal = new StringBuffer();
        block11: for (int i = 0; i < str.length(); ++i) {
            switch (str.charAt(i)) {
                case '\u0000': {
                    continue block11;
                }
                case '\b': {
                    retVal.append("\\b");
                    continue block11;
                }
                case '\t': {
                    retVal.append("\\t");
                    continue block11;
                }
                case '\n': {
                    retVal.append("\\n");
                    continue block11;
                }
                case '\f': {
                    retVal.append("\\f");
                    continue block11;
                }
                case '\r': {
                    retVal.append("\\r");
                    continue block11;
                }
                case '\"': {
                    retVal.append("\\\"");
                    continue block11;
                }
                case '\'': {
                    retVal.append("\\'");
                    continue block11;
                }
                case '\\': {
                    retVal.append("\\\\");
                    continue block11;
                }
                default: {
                    char ch = str.charAt(i);
                    if (ch < ' ' || ch > '~') {
                        String s = "0000" + Integer.toString(ch, 16);
                        retVal.append("\\u" + s.substring(s.length() - 4, s.length()));
                        continue block11;
                    }
                    retVal.append(ch);
                }
            }
        }
        return retVal.toString();
    }

    protected static String LexicalError(boolean EOFSeen, int lexState, int errorLine, int errorColumn, String errorAfter, char curChar) {
        return "Lexical error at line " + errorLine + ", column " + errorColumn + ".  Encountered: " + (EOFSeen ? "<EOF> " : "\"" + TokenMgrError.addEscapes(String.valueOf(curChar)) + "\"" + " (" + curChar + "), ") + "after : \"" + TokenMgrError.addEscapes(errorAfter) + "\"";
    }

    @Override
    public String getMessage() {
        return super.getMessage();
    }

    public TokenMgrError() {
    }

    public TokenMgrError(String message, int reason) {
        super(message);
        this.errorCode = reason;
    }

    public TokenMgrError(boolean EOFSeen, int lexState, int errorLine, int errorColumn, String errorAfter, char curChar, int reason) {
        this(TokenMgrError.LexicalError(EOFSeen, lexState, errorLine, errorColumn, errorAfter, curChar), reason);
    }
}

