/*
 * Decompiled with CFR 0.152.
 */
package prefuse.data.expression.parser;

import prefuse.data.expression.parser.Token;

public class ParseException
extends RuntimeException {
    protected boolean specialConstructor;
    public Token currentToken;
    public int[][] expectedTokenSequences;
    public String[] tokenImage;
    protected String eol = System.getProperty("line.separator", "\n");

    public ParseException(Token currentTokenVal, int[][] expectedTokenSequencesVal, String[] tokenImageVal) {
        super("");
        this.specialConstructor = true;
        this.currentToken = currentTokenVal;
        this.expectedTokenSequences = expectedTokenSequencesVal;
        this.tokenImage = tokenImageVal;
    }

    public ParseException() {
        this.specialConstructor = false;
    }

    public ParseException(String message) {
        super(message);
        this.specialConstructor = false;
    }

    @Override
    public String getMessage() {
        if (!this.specialConstructor) {
            return super.getMessage();
        }
        String expected = "";
        int maxSize = 0;
        for (int i = 0; i < this.expectedTokenSequences.length; ++i) {
            if (maxSize < this.expectedTokenSequences[i].length) {
                maxSize = this.expectedTokenSequences[i].length;
            }
            for (int j = 0; j < this.expectedTokenSequences[i].length; ++j) {
                expected = expected + this.tokenImage[this.expectedTokenSequences[i][j]] + " ";
            }
            if (this.expectedTokenSequences[i][this.expectedTokenSequences[i].length - 1] != 0) {
                expected = expected + "...";
            }
            expected = expected + this.eol + "    ";
        }
        String retVal = "Encountered \"";
        Token tok = this.currentToken.next;
        for (int i = 0; i < maxSize; ++i) {
            if (i != 0) {
                retVal = retVal + " ";
            }
            if (tok.kind == 0) {
                retVal = retVal + this.tokenImage[0];
                break;
            }
            retVal = retVal + this.add_escapes(tok.image);
            tok = tok.next;
        }
        retVal = retVal + "\" at line " + this.currentToken.next.beginLine + ", column " + this.currentToken.next.beginColumn;
        retVal = retVal + "." + this.eol;
        retVal = this.expectedTokenSequences.length == 1 ? retVal + "Was expecting:" + this.eol + "    " : retVal + "Was expecting one of:" + this.eol + "    ";
        retVal = retVal + expected;
        return retVal;
    }

    protected String add_escapes(String str) {
        StringBuffer retVal = new StringBuffer();
        block11: for (int i = 0; i < str.length(); ++i) {
            switch (str.charAt(i)) {
                case '\u0000': {
                    continue block11;
                }
                case '\b': {
                    retVal.append("\\b");
                    continue block11;
                }
                case '\t': {
                    retVal.append("\\t");
                    continue block11;
                }
                case '\n': {
                    retVal.append("\\n");
                    continue block11;
                }
                case '\f': {
                    retVal.append("\\f");
                    continue block11;
                }
                case '\r': {
                    retVal.append("\\r");
                    continue block11;
                }
                case '\"': {
                    retVal.append("\\\"");
                    continue block11;
                }
                case '\'': {
                    retVal.append("\\'");
                    continue block11;
                }
                case '\\': {
                    retVal.append("\\\\");
                    continue block11;
                }
                default: {
                    char ch = str.charAt(i);
                    if (ch < ' ' || ch > '~') {
                        String s = "0000" + Integer.toString(ch, 16);
                        retVal.append("\\u" + s.substring(s.length() - 4, s.length()));
                        continue block11;
                    }
                    retVal.append(ch);
                }
            }
        }
        return retVal.toString();
    }
}

