/*
 * Decompiled with CFR 0.152.
 */
package prefuse.data.expression;

import java.util.ArrayList;
import java.util.Iterator;
import prefuse.data.expression.AbstractPredicate;
import prefuse.data.expression.Expression;
import prefuse.data.expression.ExpressionVisitor;
import prefuse.data.expression.Predicate;

public abstract class CompositePredicate
extends AbstractPredicate {
    protected ArrayList m_clauses = new ArrayList(2);

    public CompositePredicate() {
    }

    public CompositePredicate(Predicate p1, Predicate p2) {
        this.m_clauses.add(p1);
        this.m_clauses.add(p2);
    }

    public void add(Predicate p) {
        if (this.m_clauses.contains(p)) {
            throw new IllegalArgumentException("Duplicate predicate.");
        }
        this.m_clauses.add(p);
        this.fireExpressionChange();
    }

    public boolean remove(Predicate p) {
        if (this.m_clauses.remove(p)) {
            this.fireExpressionChange();
            return true;
        }
        return false;
    }

    public void clear() {
        this.removeChildListeners();
        this.m_clauses.clear();
        this.fireExpressionChange();
    }

    public int size() {
        return this.m_clauses.size();
    }

    public Predicate get(int idx) {
        return (Predicate)this.m_clauses.get(idx);
    }

    public void set(Predicate p) {
        this.removeChildListeners();
        this.m_clauses.clear();
        this.m_clauses.add(p);
        if (this.hasListeners()) {
            this.addChildListeners();
        }
        this.fireExpressionChange();
    }

    public void set(Predicate[] p) {
        this.removeChildListeners();
        this.m_clauses.clear();
        for (int i = 0; i < p.length; ++i) {
            if (this.m_clauses.contains(p)) continue;
            this.m_clauses.add(p[i]);
        }
        if (this.hasListeners()) {
            this.addChildListeners();
        }
        this.fireExpressionChange();
    }

    public Predicate getSubPredicate(Predicate p) {
        CompositePredicate cp = null;
        try {
            cp = (CompositePredicate)this.getClass().newInstance();
        }
        catch (InstantiationException instantiationException) {
        }
        catch (IllegalAccessException illegalAccessException) {
            // empty catch block
        }
        for (int i = 0; i < this.m_clauses.size(); ++i) {
            Predicate pp = (Predicate)this.m_clauses.get(i);
            if (p == pp) continue;
            cp.add(pp);
        }
        return cp;
    }

    @Override
    public void visit(ExpressionVisitor v) {
        v.visitExpression(this);
        Iterator iter = this.m_clauses.iterator();
        while (iter.hasNext()) {
            v.down();
            ((Expression)iter.next()).visit(v);
            v.up();
        }
    }

    @Override
    protected void addChildListeners() {
        Iterator iter = this.m_clauses.iterator();
        while (iter.hasNext()) {
            ((Expression)iter.next()).addExpressionListener(this);
        }
    }

    @Override
    protected void removeChildListeners() {
        Iterator iter = this.m_clauses.iterator();
        while (iter.hasNext()) {
            ((Expression)iter.next()).removeExpressionListener(this);
        }
    }

    protected String toString(String op) {
        if (this.m_clauses.size() == 1) {
            return this.m_clauses.get(0).toString();
        }
        StringBuffer sbuf = new StringBuffer();
        sbuf.append('(');
        Iterator iter = this.m_clauses.iterator();
        while (iter.hasNext()) {
            sbuf.append(iter.next().toString());
            if (!iter.hasNext()) continue;
            sbuf.append(" ");
            sbuf.append(op);
            sbuf.append(" ");
        }
        sbuf.append(')');
        return sbuf.toString();
    }
}

