/*
 * Decompiled with CFR 0.152.
 */
package prefuse.data.column;

import java.util.Arrays;
import prefuse.data.DataReadOnlyException;
import prefuse.data.DataTypeException;
import prefuse.data.column.AbstractColumn;

public class FloatColumn
extends AbstractColumn {
    private float[] m_values;
    private int m_size;

    public FloatColumn() {
        this(0, 10, 0.0f);
    }

    public FloatColumn(int nRows) {
        this(nRows, nRows, 0.0f);
    }

    public FloatColumn(int nRows, int capacity, float defaultValue) {
        super(Float.TYPE, new Float(defaultValue));
        if (capacity < nRows) {
            throw new IllegalArgumentException("Capacity value can not be less than the row count.");
        }
        this.m_values = new float[capacity];
        Arrays.fill(this.m_values, defaultValue);
        this.m_size = nRows;
    }

    @Override
    public int getRowCount() {
        return this.m_size;
    }

    @Override
    public void setMaximumRow(int nRows) {
        if (nRows > this.m_values.length) {
            int capacity = Math.max(3 * this.m_values.length / 2 + 1, nRows);
            float[] values = new float[capacity];
            System.arraycopy(this.m_values, 0, values, 0, this.m_size);
            Arrays.fill(values, this.m_size, capacity, ((Float)this.m_defaultValue).floatValue());
            this.m_values = values;
        }
        this.m_size = nRows;
    }

    @Override
    public Object get(int row) {
        return new Float(this.getFloat(row));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void set(Object val, int row) throws DataTypeException {
        if (this.m_readOnly) {
            throw new DataReadOnlyException();
        }
        if (val == null) throw new DataTypeException("Column does not accept null values");
        if (val instanceof Number) {
            this.setFloat(((Number)val).floatValue(), row);
            return;
        } else {
            if (!(val instanceof String)) throw new DataTypeException(val.getClass());
            this.setString((String)val, row);
        }
    }

    @Override
    public float getFloat(int row) throws DataTypeException {
        if (row < 0 || row > this.m_size) {
            throw new IllegalArgumentException("Row index out of bounds: " + row);
        }
        return this.m_values[row];
    }

    @Override
    public void setFloat(float val, int row) throws DataTypeException {
        if (this.m_readOnly) {
            throw new DataReadOnlyException();
        }
        if (row < 0 || row >= this.m_size) {
            throw new IllegalArgumentException("Row index out of bounds: " + row);
        }
        float prev = this.m_values[row];
        if (prev == val) {
            return;
        }
        this.m_values[row] = val;
        this.fireColumnEvent(row, prev);
    }

    @Override
    public int getInt(int row) throws DataTypeException {
        return (int)this.getFloat(row);
    }

    @Override
    public long getLong(int row) throws DataTypeException {
        return (long)this.getFloat(row);
    }

    @Override
    public double getDouble(int row) throws DataTypeException {
        return this.getFloat(row);
    }
}

